/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import oracle.eclipse.tools.adf.debugger.ui.views.data.ClickableValue;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIPlaceholderVariable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPane;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class AdfDataTableViewer
extends TreeModelViewer {
    private DefaultDetailPane detailPane = null;

    public AdfDataTableViewer(Composite parent, int style, IPresentationContext context) {
        super(parent, style, context);
    }

    public void setDefaultDetailPane(DefaultDetailPane pane) {
        this.detailPane = pane;
    }

    public void initViewer() {
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JDIPlaceholderVariable value;
                Object obj;
                TreeSelection ts = (TreeSelection)event.getSelection();
                Object o = ts.getFirstElement();
                if (o instanceof JDIPlaceholderVariable && (obj = (value = (JDIPlaceholderVariable)((Object)o)).getAdapter(ClickableValue.class)) != null) {
                    try {
                        ClickableValue link = (ClickableValue)obj;
                        link.open();
                    }
                    catch (CoreException ce) {
                        ce.printStackTrace();
                    }
                }
                if (AdfDataTableViewer.this.detailPane != null) {
                    AdfDataTableViewer.this.detailPane.display((IStructuredSelection)ts);
                }
            }
        });
        final Tree tree = this.getTree();
        tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                JDIPlaceholderVariable var;
                TreeItem item = (TreeItem)event.item;
                TreeColumn tc0 = tree.getColumn(0);
                TreeColumn tc1 = tree.getColumn(1);
                Object o = item.getData();
                if (o instanceof JDIPlaceholderVariable && (var = (JDIPlaceholderVariable)((Object)o)).getAdapter(ClickableValue.class) != null) {
                    int itemHeight = tree.getItemHeight();
                    int itemWidth = item.getBounds().width;
                    int n = tc0.getWidth();
                    int n1 = tc1.getWidth();
                    if (event.x >= n && event.x < n + n1) {
                        Color color = Display.getDefault().getSystemColor(9);
                        event.gc.setForeground(color);
                        int width = itemWidth;
                        if (item.getText(0) != null && item.getText(0).length() > 0) {
                            width = itemWidth * item.getText(1).length() / item.getText(0).length();
                        }
                        event.gc.drawLine(event.x + 5, event.y + itemHeight - 2, event.x + 5 + width, event.y + itemHeight - 2);
                    }
                }
            }
        });
    }
}

