/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.adf.share.dt.debug.AdfContextDebugArb;
import oracle.adf.share.dt.debug.AdfContextElement;
import oracle.adf.share.dt.debug.DataRootElement;
import oracle.adf.share.dt.debug.TypeColumn;
import oracle.adfdt.debug.common.DebuggeeDataDecorator;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DefaultDataContentProvider;
import oracle.ide.Context;
import oracle.ide.model.DataColumn;
import oracle.ide.model.Element;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;

class AdfContextDataContentProvider
extends DefaultDataContentProvider {
    private static final String GET_APPLICATION_NAME = "getApplicationName()";
    private static final String IS_HTTP_CONTEXT = "isHttpContext()";
    private static final String GET_SKIPLEVEL_IDENTIFIER = "getSkipLevelIdentifier()";
    private static final String GET_LOCALE = "getLocale()";
    private static final String HAS_ENVIRONMENT = "hasEnvironment()";
    private static final String IS_DESIGN_TIME = "isDesignTime()";
    private static final String GET_CONTEXT_TYPE = "getContextTypeName()";
    private static final String SECURITY_CONTEXT = "securityContext";
    private static final String APPLICATION_NAME_SHORT_LABEL = AdfContextDebugArb.APPLICATION_NAME_SHORT_LABEL;
    private static final String HTTP_CONTEXT_SHORT_LABEL = AdfContextDebugArb.HTTP_CONTEXT_SHORT_LABEL;
    private static final String LOCALE_SHORT_LABEL = AdfContextDebugArb.LOCALE_SHORT_LABEL;
    private static final String HAS_ENVIRONMENT_SHORT_LABEL = AdfContextDebugArb.HAS_ENVIRONMENT_SHORT_LABEL;
    private static final String ISDESIGNTIME_SHORT_LABEL = AdfContextDebugArb.ISDESIGNTIME_SHORT_LABEL;
    private static final String CONTEXT_TYPE_SHORT_LABEL = AdfContextDebugArb.CONTEXT_TYPE_SHORT_LABEL;
    private static final String SKIPLEVEL_IDENTIFIER_SHORT_LABEL = AdfContextDebugArb.SKIPLEVEL_IDENTIFIER_SHORT_LABEL;
    private static final DataColumn TYPE_COLUMN = new TypeColumn();
    private static final List<DataColumn> ADDITIONAL_COLUMNS = Collections.singletonList(TYPE_COLUMN);

    AdfContextDataContentProvider() {
    }

    @Override
    public List<Element> getChildren(Element structureElement, Element parentElement, Context context, DebuggerEvaluator evaluator) {
        if (structureElement instanceof AdfContextElement && parentElement instanceof DataRootElement) {
            AdfContextElement adfContextElement = (AdfContextElement)structureElement;
            DebuggeeData adfContextAsDebuggeeData = adfContextElement.asDebuggeeData();
            LinkedList<Element> children = new LinkedList<Element>();
            DebuggeeData applicationNameAsDebuggeeData = evaluator.evaluate(GET_APPLICATION_NAME, adfContextAsDebuggeeData);
            DebuggeeData hasEnvAsDebuggeeData = evaluator.evaluate(HAS_ENVIRONMENT, adfContextAsDebuggeeData);
            DebuggeeData skipLevelAsDebuggeeData = evaluator.evaluate(GET_SKIPLEVEL_IDENTIFIER, adfContextAsDebuggeeData);
            DebuggeeData isDTSessionAsDebuggeeData = evaluator.evaluate(IS_DESIGN_TIME, adfContextAsDebuggeeData);
            DebuggeeData getCtxTypeAsDebuggeeData = evaluator.evaluate(GET_CONTEXT_TYPE, adfContextAsDebuggeeData);
            DebuggeeData isHttpCtxAsDebuggeeData = evaluator.evaluate(IS_HTTP_CONTEXT, adfContextAsDebuggeeData);
            DebuggeeData localeAsDebuggeeData = evaluator.evaluate(GET_LOCALE, adfContextAsDebuggeeData);
            DebuggeeData secCtxAsDebuggeeData = evaluator.evaluate(SECURITY_CONTEXT, adfContextAsDebuggeeData);
            children.add(new DebuggeeDataDecorator(APPLICATION_NAME_SHORT_LABEL, "APPLICATION", applicationNameAsDebuggeeData));
            children.add(new DebuggeeDataDecorator(HAS_ENVIRONMENT_SHORT_LABEL, hasEnvAsDebuggeeData));
            children.add(new DebuggeeDataDecorator(SKIPLEVEL_IDENTIFIER_SHORT_LABEL, skipLevelAsDebuggeeData));
            children.add(new DebuggeeDataDecorator(HTTP_CONTEXT_SHORT_LABEL, isHttpCtxAsDebuggeeData));
            children.add(new DebuggeeDataDecorator(LOCALE_SHORT_LABEL, localeAsDebuggeeData));
            children.add(new DebuggeeDataDecorator(ISDESIGNTIME_SHORT_LABEL, isDTSessionAsDebuggeeData));
            children.add(new DebuggeeDataDecorator(CONTEXT_TYPE_SHORT_LABEL, getCtxTypeAsDebuggeeData));
            children.add(new DebuggeeDataDecorator(SECURITY_CONTEXT, secCtxAsDebuggeeData));
            return children;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean includeValueColumn(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        return structureElement instanceof AdfContextElement;
    }

    public List<DataColumn> getAdditionalColumns(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        if (structureElement instanceof AdfContextElement) {
            return ADDITIONAL_COLUMNS;
        }
        return Collections.EMPTY_LIST;
    }
}

