/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.preference;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.debugger.ui.AdfDebuggerUiPlugin;
import oracle.eclipse.tools.adf.debugger.ui.preference.ADFSourceLocation;
import oracle.eclipse.tools.adf.debugger.ui.preference.ADFSourceLocationConfigDialog;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.ui.util.otn.BrowserLauncher;
import oracle.eclipse.tools.weblogic.JRFRuntimeUtil;
import oracle.eclipse.tools.weblogic.j2eelib.ClasspathEntry;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRegistry;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.wst.server.ui.internal.SWTUtil;

public class AdfSourceLocationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREFERENCE_DELIMITER = ";";
    private static final String ADF_SOURCE_PREFERENCE = "ADF_SOURCE_PREFERENCE";
    private TableViewer table;
    private Button edit;
    private Button remove;
    private HashMap<String, String> sourceLocations = new HashMap();

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(AdfDebuggerUiPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(272);
        composite.setLayoutData((Object)data);
        FormText text = new FormText(composite, 0);
        text.setText(Resources.otnLinkText, false, true);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        gd.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gd);
        text.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                try {
                    BrowserLauncher.displayURL((String)"http://www.oracle.com/technetwork/developer-tools/jdev/jdeveloper11gfaq-085697.html#MI0");
                }
                catch (IOException iOException) {}
            }
        });
        this.createSourceLocationTable(composite);
        this.createButtons(composite);
        return composite;
    }

    private void createButtons(Composite composite) {
        Composite buttonComp = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttonComp.setLayout((Layout)layout);
        GridData data = new GridData(272);
        buttonComp.setLayoutData((Object)data);
        Button add = SWTUtil.createButton((Composite)buttonComp, (String)"Add");
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ADFSourceLocationConfigDialog dlg = new ADFSourceLocationConfigDialog(AdfSourceLocationPreferencePage.this.getShell(), null);
                if (dlg.open() != 1) {
                    ADFSourceLocation loc = dlg.getADFSourceLocation();
                    AdfSourceLocationPreferencePage.this.sourceLocations.put(loc.getVersion(), loc.getLocation().getAbsolutePath());
                    AdfSourceLocationPreferencePage.this.table.refresh();
                }
            }
        });
        this.edit = SWTUtil.createButton((Composite)buttonComp, (String)"Edit");
        this.edit.setEnabled(false);
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)AdfSourceLocationPreferencePage.this.table.getSelection();
                ADFSourceLocation loc = (ADFSourceLocation)sel.getFirstElement();
                ADFSourceLocationConfigDialog dlg = new ADFSourceLocationConfigDialog(AdfSourceLocationPreferencePage.this.getShell(), loc);
                if (dlg.open() != 1) {
                    loc = dlg.getADFSourceLocation();
                    AdfSourceLocationPreferencePage.this.sourceLocations.put(loc.getVersion(), loc.getLocation().getAbsolutePath());
                    AdfSourceLocationPreferencePage.this.table.refresh();
                }
            }
        });
        this.remove = SWTUtil.createButton((Composite)buttonComp, (String)"Remove");
        this.remove.setEnabled(false);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)AdfSourceLocationPreferencePage.this.table.getSelection();
                ADFSourceLocation loc = (ADFSourceLocation)sel.getFirstElement();
                AdfSourceLocationPreferencePage.this.sourceLocations.remove(loc.getVersion());
                AdfSourceLocationPreferencePage.this.table.refresh();
            }
        });
    }

    private void createSourceLocationTable(Composite comp) {
        Composite composite = new Composite(comp, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        this.table = new TableViewer(composite, 67586);
        this.table.getTable().setLayoutData((Object)SwtUtil.gdfill());
        this.table.getTable().setLinesVisible(true);
        this.table.setContentProvider((IContentProvider)new TableContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        TableColumn column1 = new TableColumn(this.table.getTable(), 16384);
        column1.setText(Resources.versionColumnLabel);
        TableColumn column2 = new TableColumn(this.table.getTable(), 16384);
        column2.setText(Resources.locationColumnLabel);
        column2.setWidth(450);
        TableColumnLayout layout = new TableColumnLayout();
        this.table.getControl().getParent().setLayout((Layout)layout);
        layout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(30));
        layout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(70));
        this.table.getTable().setHeaderVisible(true);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel;
                if (event.getSelection() != null && (sel = (IStructuredSelection)AdfSourceLocationPreferencePage.this.table.getSelection()) != null) {
                    AdfSourceLocationPreferencePage.this.edit.setEnabled(true);
                    AdfSourceLocationPreferencePage.this.remove.setEnabled(true);
                }
            }
        });
        String pref = this.getPreferenceStore().getString(ADF_SOURCE_PREFERENCE);
        if (pref != null && pref.length() > 0) {
            String[] values;
            String[] stringArray = values = pref.split(PREFERENCE_DELIMITER);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                String[] kv = val.split("=");
                this.sourceLocations.put(kv[0], kv[1]);
                ++n2;
            }
        }
        this.table.setInput(this.sourceLocations);
    }

    public boolean performOk() {
        StringBuilder sb = new StringBuilder();
        for (String version : this.sourceLocations.keySet()) {
            String path = this.sourceLocations.get(version);
            sb.append(String.valueOf(version) + "=" + path + PREFERENCE_DELIMITER);
            this.updateADFLibSourceLocation(version, path);
        }
        this.getPreferenceStore().setValue(ADF_SOURCE_PREFERENCE, sb.toString());
        return super.performOk();
    }

    protected void performApply() {
        super.performApply();
    }

    private void updateADFLibSourceLocation(String version, String path) {
        LibraryModule[] modules;
        ADFSourceLocationConfigDialog.BundleInfo info = ADFSourceLocationConfigDialog.getADFSrcBundleInfo(new File(path));
        if (info == null) {
            this.updateWithExpandedSourceFodler(version, path);
            return;
        }
        HashMap<String, String> jrfVersionMap = new HashMap<String, String>();
        File sourceDir = new File(path);
        HashMap<String, String> sourcePathMap = new HashMap<String, String>();
        this.buildSourcePathMap(sourceDir, sourcePathMap);
        LibraryModuleRegistry regsitry = LibraryModulesSvc.getRegistry();
        LibraryModule[] libraryModuleArray = modules = regsitry.list();
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            LibraryModule m = libraryModuleArray[n2];
            String name = m.getName();
            if (name.contains("adf")) {
                try {
                    File libLocation = m.getLocation();
                    File oracleCommonModuleFolder = libLocation.getParentFile();
                    if (!oracleCommonModuleFolder.getName().equals("modules")) {
                        oracleCommonModuleFolder = oracleCommonModuleFolder.getParentFile();
                    }
                    String jrfImplVersion = null;
                    if (jrfVersionMap.containsKey(oracleCommonModuleFolder.getAbsolutePath())) {
                        jrfImplVersion = (String)jrfVersionMap.get(oracleCommonModuleFolder.getAbsolutePath());
                    } else {
                        jrfImplVersion = JRFRuntimeUtil.getJRFRuntimeImplVersionFrom((File)oracleCommonModuleFolder);
                        if (jrfImplVersion.endsWith(".0")) {
                            jrfImplVersion = jrfImplVersion.substring(0, jrfImplVersion.length() - 2);
                        }
                        jrfVersionMap.put(oracleCommonModuleFolder.getAbsolutePath(), jrfImplVersion);
                    }
                    if (version.startsWith(jrfImplVersion)) {
                        HashMap<String, File> sourceLocationMap = new HashMap<String, File>(m.getSourceLocations());
                        boolean changed = false;
                        for (ClasspathEntry e : m.getClasspathEntries()) {
                            File jarFile = e.getLocation();
                            if (jarFile.isDirectory()) continue;
                            String p = jarFile.getName();
                            String relativePath = e.getRelativePath();
                            File sourceLocation = e.getSourceLocaton();
                            String oldSourcePath = sourceLocation == null ? "" : sourceLocation.getAbsolutePath();
                            String jarName = p.substring(0, p.indexOf(".jar"));
                            String sourcePath = sourcePathMap.get(String.valueOf(jarName) + ".zip");
                            if (sourcePath != null && !oldSourcePath.equals(sourcePath)) {
                                sourceLocationMap.put(relativePath, new File(sourcePath));
                                changed = true;
                                continue;
                            }
                            sourcePath = sourcePathMap.get(String.valueOf(jarName) + "_src.zip");
                            if (sourcePath != null && !oldSourcePath.equals(sourcePath)) {
                                sourceLocationMap.put(relativePath, new File(sourcePath));
                                changed = true;
                                continue;
                            }
                            sourcePath = sourcePathMap.get(String.valueOf(jarName) + "src.zip");
                            if (sourcePath != null && !oldSourcePath.equals(sourcePath)) {
                                sourceLocationMap.put(relativePath, new File(sourcePath));
                                changed = true;
                                continue;
                            }
                            sourcePath = sourcePathMap.get(String.valueOf(jarName) + "-src.zip");
                            if (sourcePath == null || oldSourcePath.equals(sourcePath)) continue;
                            sourceLocationMap.put(relativePath, new File(sourcePath));
                            changed = true;
                        }
                        if (changed) {
                            this.setAdfLibSourcePath(m, sourceLocationMap);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void updateWithExpandedSourceFodler(String version, String sourceFolderPath) {
        LibraryModule[] modules;
        HashMap<String, String> jrfVersionMap = new HashMap<String, String>();
        LibraryModuleRegistry regsitry = LibraryModulesSvc.getRegistry();
        LibraryModule[] libraryModuleArray = modules = regsitry.list();
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            LibraryModule m = libraryModuleArray[n2];
            String name = m.getName();
            if (name.contains("adf")) {
                try {
                    File libLocation = m.getLocation();
                    File oracleCommonModuleFolder = libLocation.getParentFile();
                    if (!oracleCommonModuleFolder.getName().equals("modules")) {
                        oracleCommonModuleFolder = oracleCommonModuleFolder.getParentFile();
                    }
                    String jrfImplVersion = null;
                    if (jrfVersionMap.containsKey(oracleCommonModuleFolder.getAbsolutePath())) {
                        jrfImplVersion = (String)jrfVersionMap.get(oracleCommonModuleFolder.getAbsolutePath());
                    } else {
                        jrfImplVersion = JRFRuntimeUtil.getJRFRuntimeImplVersionFrom((File)oracleCommonModuleFolder);
                        if (jrfImplVersion.endsWith(".0")) {
                            jrfImplVersion = jrfImplVersion.substring(0, jrfImplVersion.length() - 2);
                        }
                        jrfVersionMap.put(oracleCommonModuleFolder.getAbsolutePath(), jrfImplVersion);
                    }
                    if (version.startsWith(jrfImplVersion)) {
                        HashMap<String, File> sourceLocationMap = new HashMap<String, File>(m.getSourceLocations());
                        boolean changed = false;
                        for (ClasspathEntry e : m.getClasspathEntries()) {
                            File jarFile = e.getLocation();
                            if (jarFile.isDirectory()) continue;
                            String relativePath = e.getRelativePath();
                            File sourceLocation = e.getSourceLocaton();
                            String oldSourcePath = sourceLocation == null ? "" : sourceLocation.getAbsolutePath();
                            String sourcePath = sourceFolderPath;
                            if (sourcePath == null || oldSourcePath.equals(sourcePath)) continue;
                            sourceLocationMap.put(relativePath, new File(sourcePath));
                            changed = true;
                        }
                        if (changed) {
                            this.setAdfLibSourcePath(m, sourceLocationMap);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void setAdfLibSourcePath(LibraryModule oldLibMoudle, Map<String, File> sourceLocations) {
        try {
            LibraryModuleRegistry registry = LibraryModulesSvc.getRegistry();
            LibraryModule libmodule = new LibraryModule(oldLibMoudle.getLocation(), oldLibMoudle.getName(), oldLibMoudle.getSpecificationVersion(), oldLibMoudle.getImplementationVersion(), sourceLocations, oldLibMoudle.getJavadocLocations(), LibraryModulesSvc.getTempDir());
            registry.swap(oldLibMoudle, libmodule);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildSourcePathMap(File dir, HashMap<String, String> sourcePathMap) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.buildSourcePathMap(f, sourcePathMap);
            } else if (f.getName().endsWith(".zip")) {
                sourcePathMap.put(f.getName(), f.getAbsolutePath());
            }
            ++n2;
        }
    }

    private static final class Resources
    extends NLS {
        public static String otnLinkText;
        public static String locationColumnLabel;
        public static String versionColumnLabel;

        static {
            Resources.initializeMessages((String)AdfSourceLocationPreferencePage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private final class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object element) {
            HashMap sourceLoc = (HashMap)element;
            Object[] ret = new ADFSourceLocation[sourceLoc.size()];
            int n = 0;
            for (String v : sourceLoc.keySet()) {
                String loc = (String)sourceLoc.get(v);
                ret[n] = new ADFSourceLocation(v, new File(loc));
                ++n;
            }
            return ret;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private static final class TableLabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public String getColumnText(Object element, int column) {
            ADFSourceLocation sourceLocation = (ADFSourceLocation)element;
            switch (column) {
                case 1: {
                    return sourceLocation.getVersion();
                }
                case 2: {
                    return sourceLocation.getLocation().getAbsolutePath();
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int column) {
            return null;
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }
}

