/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.diagram;

import java.util.HashMap;
import oracle.eclipse.tools.adf.debugger.AdfDebugModel;
import oracle.eclipse.tools.adf.debugger.lifecycle.IAdfLifecyclePhaseBreakpoint;
import oracle.eclipse.tools.adf.debugger.ui.OracleIcons;
import oracle.eclipse.tools.adf.debugger.ui.diagram.FixedAnchor;
import oracle.eclipse.tools.common.services.ui.Activator;
import oracle.eclipse.tools.common.ui.diagram.figures.NodeDiagramStyleSheets;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class LifecyclePhaseFigure
extends Figure {
    public static Color backgroundColor = new Color(null, 204, 255, 255);
    public static Color hightlightColor = new Color(null, 255, 255, 0);
    public FixedAnchor topInAnchor;
    public FixedAnchor bottomOutAnchor;
    public FixedAnchor leftInAnchor;
    public FixedAnchor rightOutAnchor;
    Label beforePhaseBreapointCheckBox = null;
    Label afterPhaseBreapointCheckBox = null;
    boolean isSelected = false;
    boolean isBreakpointHit = false;
    boolean isBreakpointEnabled = false;
    private IAdfLifecyclePhaseBreakpoint adfLifecyclePhaseBreakpoint = null;
    private boolean isStopBeforePhase = false;

    public LifecyclePhaseFigure(String phaseName) {
        this(phaseName, false);
    }

    public LifecyclePhaseFigure(final String phaseName, boolean isJsfLifecycle) {
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 7;
        gl.marginHeight = 8;
        this.setLayoutManager((LayoutManager)gl);
        this.beforePhaseBreapointCheckBox = new Label(OracleIcons.getIcon("/breakpoint/UNCHECKED"));
        this.add((IFigure)this.beforePhaseBreapointCheckBox);
        this.beforePhaseBreapointCheckBox.addMouseListener(new MouseListener(){

            public void mouseDoubleClicked(MouseEvent me) {
            }

            public void mousePressed(MouseEvent me) {
            }

            public void mouseReleased(MouseEvent me) {
                LifecyclePhaseFigure.this.updateBeforePhaseBreakpoint(phaseName);
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        gridData.verticalAlignment = 0x1000000;
        gl.setConstraint((IFigure)this.beforePhaseBreapointCheckBox, (Object)gridData);
        Label label = new Label(phaseName);
        label.setForegroundColor(NodeDiagramStyleSheets.HEADER_LABEL_COLOR);
        label.setFont(NodeDiagramStyleSheets.getChildLabelFont());
        this.add((IFigure)label);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        gridData.verticalAlignment = 0x1000000;
        gridData.widthHint = 150;
        gl.setConstraint((IFigure)label, (Object)gridData);
        this.afterPhaseBreapointCheckBox = new Label(OracleIcons.getIcon("/breakpoint/UNCHECKED"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 0x1000000;
        gl.setConstraint((IFigure)this.afterPhaseBreapointCheckBox, (Object)gridData);
        this.add((IFigure)this.afterPhaseBreapointCheckBox);
        this.afterPhaseBreapointCheckBox.addMouseListener(new MouseListener(){

            public void mouseDoubleClicked(MouseEvent me) {
            }

            public void mousePressed(MouseEvent me) {
            }

            public void mouseReleased(MouseEvent me) {
                LifecyclePhaseFigure.this.updateAfterPhaseBreakpoint(phaseName);
            }
        });
        this.leftInAnchor = new FixedAnchor((IFigure)this);
        this.leftInAnchor.point = new Point(0, 1);
        this.rightOutAnchor = new FixedAnchor((IFigure)this);
        this.rightOutAnchor.point = new Point(2, 1);
        this.topInAnchor = new FixedAnchor((IFigure)this);
        this.topInAnchor.point = new Point(1, 0);
        this.bottomOutAnchor = new FixedAnchor((IFigure)this);
        this.bottomOutAnchor.point = new Point(1, 2);
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
            }

            public void keyReleased(KeyEvent ke) {
            }
        });
        if (isJsfLifecycle) {
            this.afterPhaseBreapointCheckBox.setVisible(false);
            this.beforePhaseBreapointCheckBox.setVisible(false);
        } else {
            this.setBackgroundColor(new Color(null, 255, 255, 204));
        }
    }

    private void updateAfterPhaseBreakpoint(String phaseName) {
        try {
            if (this.adfLifecyclePhaseBreakpoint != null) {
                if (this.adfLifecyclePhaseBreakpoint.isAfter()) {
                    if (this.adfLifecyclePhaseBreakpoint.isBefore()) {
                        this.adfLifecyclePhaseBreakpoint.setAfter(false);
                        this.repaint();
                    } else {
                        this.adfLifecyclePhaseBreakpoint.delete();
                        this.setData(null);
                    }
                } else {
                    this.adfLifecyclePhaseBreakpoint.setAfter(true);
                    this.repaint();
                }
            } else {
                IAdfLifecyclePhaseBreakpoint breakpoint = this.findLifecyclePhaseBreakpoint(phaseName);
                if (breakpoint != null) {
                    breakpoint.setEnabled(true);
                    breakpoint.setAfter(true);
                } else {
                    HashMap attributes = new HashMap();
                    breakpoint = AdfDebugModel.createLifecyclePhaseBreakpoint((String)phaseName, (boolean)false, (boolean)true, (boolean)true, attributes);
                }
                this.setData(breakpoint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateBeforePhaseBreakpoint(String phaseName) {
        try {
            if (this.adfLifecyclePhaseBreakpoint != null) {
                if (this.adfLifecyclePhaseBreakpoint.isBefore()) {
                    if (this.adfLifecyclePhaseBreakpoint.isAfter()) {
                        this.adfLifecyclePhaseBreakpoint.setBefore(false);
                        this.repaint();
                    } else {
                        this.adfLifecyclePhaseBreakpoint.delete();
                        this.setData(null);
                    }
                } else {
                    this.adfLifecyclePhaseBreakpoint.setBefore(true);
                    this.repaint();
                }
            } else {
                IAdfLifecyclePhaseBreakpoint breakpoint = this.findLifecyclePhaseBreakpoint(phaseName);
                if (breakpoint != null) {
                    breakpoint.setEnabled(true);
                    breakpoint.setBefore(true);
                } else {
                    HashMap attributes = new HashMap();
                    breakpoint = AdfDebugModel.createLifecyclePhaseBreakpoint((String)phaseName, (boolean)true, (boolean)false, (boolean)true, attributes);
                }
                this.setData(breakpoint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private IAdfLifecyclePhaseBreakpoint findLifecyclePhaseBreakpoint(String phaseName) {
        IBreakpointManager brkptMge = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = brkptMge.getBreakpoints();
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAdfLifecyclePhaseBreakpoint adfBrkpt;
            IBreakpoint bp = iBreakpointArray[n2];
            if (bp instanceof IAdfLifecyclePhaseBreakpoint && (adfBrkpt = (IAdfLifecyclePhaseBreakpoint)bp).getPhaseName().equals(phaseName)) {
                return adfBrkpt;
            }
            ++n2;
        }
        return null;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintClientArea(graphics);
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        graphics.fillRectangle(rect);
        rect = this.getBounds().getCopy();
        if (this.adfLifecyclePhaseBreakpoint != null) {
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            Image icon = OracleIcons.getIcon("/breakpoint/UNCHECKED");
            if (this.adfLifecyclePhaseBreakpoint.isBefore()) {
                icon = breakpointManager.isEnabled() ? OracleIcons.getIcon("/breakpoint/CHECKED") : OracleIcons.getIcon("/breakpoint/CHECKED_DISABLED");
            }
            this.beforePhaseBreapointCheckBox.setIcon(icon);
            icon = OracleIcons.getIcon("/breakpoint/UNCHECKED");
            if (this.adfLifecyclePhaseBreakpoint.isAfter()) {
                icon = breakpointManager.isEnabled() ? OracleIcons.getIcon("/breakpoint/CHECKED") : OracleIcons.getIcon("/breakpoint/CHECKED_DISABLED");
            }
            this.afterPhaseBreapointCheckBox.setIcon(icon);
        } else {
            this.beforePhaseBreapointCheckBox.setIcon(OracleIcons.getIcon("/breakpoint/UNCHECKED"));
            this.afterPhaseBreapointCheckBox.setIcon(OracleIcons.getIcon("/breakpoint/UNCHECKED"));
        }
        if (this.isBreakpointHit) {
            Image centerImage = Activator.Images.HEADER_BKGND_CENTER_IMAGE.getImage();
            org.eclipse.swt.graphics.Rectangle imageRect = centerImage.getBounds();
            graphics.drawImage(centerImage, 0, 0, imageRect.width, imageRect.height, rect.x + 1, rect.y + 1, rect.width - 3, rect.height - 2);
            if (this.isStopBeforePhase) {
                this.beforePhaseBreapointCheckBox.setIcon(OracleIcons.getIcon("/breakpoint/CHECKED_IP"));
            } else {
                this.afterPhaseBreapointCheckBox.setIcon(OracleIcons.getIcon("/breakpoint/CHECKED_IP"));
            }
        }
        if (this.isSelected) {
            graphics.setLineWidth(2);
            rect = rect.expand(new Insets(-2, -2, -2, -3));
        } else {
            graphics.setLineWidth(1);
            rect = rect.expand(new Insets(-1, -1, -1, -2));
        }
        graphics.setForegroundColor(NodeDiagramStyleSheets.ROOT_NODE_OUTLINE_HILITE_COLOR);
        graphics.drawRoundRectangle(rect, 6, 6);
        graphics.popState();
        super.paintFigure(graphics);
    }

    public void setSelect(boolean isSelected) {
        this.isSelected = isSelected;
        this.repaint();
    }

    public void setEnableBrekpoint(boolean val, boolean isBeforePhase) {
        this.isBreakpointEnabled = val;
        this.repaint();
    }

    public void setBreakpointHit(boolean val, boolean isStopBeforePhase) {
        this.isBreakpointHit = val;
        this.isStopBeforePhase = isStopBeforePhase;
        this.repaint();
    }

    public void setData(IAdfLifecyclePhaseBreakpoint adfBrkpt) {
        this.adfLifecyclePhaseBreakpoint = adfBrkpt;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LifecyclePhaseFigure.this.repaint();
            }
        });
    }
}

