/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.diagram;

import oracle.eclipse.tools.adf.debugger.ui.AdfDebuggerUiPlugin;
import oracle.eclipse.tools.adf.debugger.ui.AdfLifecyclePhase;
import oracle.eclipse.tools.adf.debugger.ui.AdfLifecyclePhaseEditorInput;
import oracle.eclipse.tools.adf.debugger.ui.diagram.AdfLifecycleDiagram;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class AdfLifecycleDiagramEditor
extends EditorPart {
    public static final String ID = "oracle.eclipse.tools.adf.debugger.ui.AdfLifecycleDiagramEditor";
    private static final String HELP_CONTEXT_ID = "oracle.eclipse.tools.adf.doc.adf_lifecycle";
    AdfLifecycleDiagram diagram = null;
    FigureCanvas canvas = null;
    private IAction openDataViewAction = new Action(){

        public void run() {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.showView("oracle.eclipse.tools.adf.debugger.ui.AdfStructureView");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public ImageDescriptor getImageDescriptor() {
            String imageFilePath = "/icons/adf_structure.png";
            ImageDescriptor desc = AdfDebuggerUiPlugin.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.adf.debugger.ui", (String)imageFilePath);
            return desc;
        }

        public String getText() {
            return "Open ADF Structure and Data View";
        }
    };
    private IAction zoomInAction = new Action(){

        public void run() {
            AdfLifecycleDiagramEditor.this.zoomIn();
        }

        public ImageDescriptor getImageDescriptor() {
            String imageFilePath = "icons/zoomin.png";
            ImageDescriptor desc = AdfDebuggerUiPlugin.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.adf.debugger.ui", (String)imageFilePath);
            return desc;
        }

        public String getText() {
            return "Zoom in";
        }
    };
    private IAction zoomOutAction = new Action(){

        public void run() {
            AdfLifecycleDiagramEditor.this.zoomOut();
        }

        public ImageDescriptor getImageDescriptor() {
            String imageFilePath = "icons/zoomout.png";
            ImageDescriptor desc = AdfDebuggerUiPlugin.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.adf.debugger.ui", (String)imageFilePath);
            return desc;
        }

        public String getText() {
            return "Zoom Out";
        }
    };
    private IAction helpAction = new Action(){

        public void run() {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(AdfLifecycleDiagramEditor.HELP_CONTEXT_ID);
        }

        public String getText() {
            return "Help";
        }
    };

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.closeOtherEditorInstances(input);
    }

    private void closeOtherEditorInstances(IEditorInput input) throws PartInitException {
        IEditorReference[] editors;
        IWorkbenchWindow dwindow = DebugUIPlugin.getActiveWorkbenchWindow();
        if (dwindow == null) {
            return;
        }
        IWorkbenchPage page = dwindow.getActivePage();
        if (page == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = editors = page.findEditors(null, ID, 2);
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart p;
            IEditorReference ref = iEditorReferenceArray[n2];
            if (ref.getEditorInput() != input && (p = ref.getEditor(false)) != null) {
                page.closeEditor(p, false);
            }
            ++n2;
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.canvas = new FigureCanvas(parent, 0);
        this.diagram = new AdfLifecycleDiagram();
        Figure fig = this.diagram.getContents();
        this.canvas.setContents((IFigure)fig);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.canvas, HELP_CONTEXT_ID);
        this.updateSelection();
        this.createContextMenu(parent);
    }

    private void createContextMenu(Composite parent) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AdfLifecycleDiagramEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)parent);
        this.canvas.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.diagram);
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.openDataViewAction.setEnabled(true);
        manager.add(this.openDataViewAction);
        manager.add(this.zoomInAction);
        manager.add(this.zoomOutAction);
        manager.add(this.helpAction);
    }

    private void updateSelection() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof AdfLifecyclePhaseEditorInput) {
            AdfLifecyclePhaseEditorInput input = (AdfLifecyclePhaseEditorInput)editorInput;
            AdfLifecyclePhase phase = input.getPhase();
            final String phaseName = phase.getPhaseName();
            final boolean isBreakBefore = phase.isBreakBeforePhase();
            if (phaseName != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AdfLifecycleDiagramEditor.this.selectPhase(phaseName, isBreakBefore);
                    }
                });
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.diagram.dispose();
    }

    public void zoomIn() {
        this.diagram.zoomIn();
    }

    public void zoomOut() {
        this.diagram.zoomOut();
    }

    public void selectPhase(String phaseName, boolean isBeforePhase) {
        Rectangle rect2;
        if (phaseName == null || this.canvas.isDisposed()) {
            return;
        }
        Figure fig = this.diagram.setBreakpointHit(phaseName, isBeforePhase);
        Rectangle rect = this.canvas.getViewport().getBounds();
        if (!rect.contains(rect2 = fig.getBounds())) {
            this.canvas.scrollToY(rect2.y - rect.y / 2);
        }
    }

    public void resetHighlight() {
        this.diagram.resetHightLight();
    }

    public void setFocus() {
    }
}

