/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui;

import oracle.eclipse.tools.weblogic.server.internal.util.ServerLaunchUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class AdfLifecyclePhase
implements IAdaptable {
    private String phaseName = null;
    private boolean isBreakBeforePhase = false;
    private boolean isBreakAfterPhase = false;
    private JDIStackFrame frameStack;

    public boolean isBreakBeforePhase() {
        return this.isBreakBeforePhase;
    }

    public boolean isBreakAfterPhase() {
        return this.isBreakAfterPhase;
    }

    public String getPhaseName() {
        this.initFieldData();
        return this.phaseName;
    }

    public void setStackFrame(JDIStackFrame f) {
        this.frameStack = f;
    }

    private void initFieldData() {
        if (this.frameStack == null) {
            return;
        }
        try {
            IJavaThread thread;
            JDIDebugTarget jdiTarget;
            IJavaType[] types;
            String typeName = this.frameStack.getDeclaringTypeName();
            if ("oracle.adf.controller.internal.debug.AdfLifecycleBreakpointFacadeFwk".equals(typeName) && (types = (jdiTarget = (JDIDebugTarget)(thread = (IJavaThread)this.frameStack.getThread()).getDebugTarget()).getJavaTypes("oracle.adf.share.ADFContext")) != null && types.length > 0) {
                IJavaVariable phaseNameVar = this.frameStack.findVariable("phaseName");
                IJavaVariable phaseBoundaryVar = this.frameStack.findVariable("phaseBoundaryName");
                if (phaseNameVar != null) {
                    IValue value = phaseNameVar.getValue();
                    StringBuilder sb = new StringBuilder();
                    char[] cArray = value.getValueString().toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if (c != '\"') {
                            sb.append(c);
                        }
                        ++n2;
                    }
                    value = phaseBoundaryVar.getValue();
                    String phaseBoundary = value != null ? value.toString() : "";
                    boolean isAfterPhase = "\"AFTER_PHASE\"".equals(phaseBoundary);
                    this.phaseName = sb.toString();
                    this.isBreakAfterPhase = isAfterPhase;
                    this.isBreakBeforePhase = !isAfterPhase;
                }
            }
        }
        catch (Exception exception) {}
    }

    public JDIStackFrame getStackFrame() {
        return this.frameStack;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IJavaElement.class) {
            JDIDebugTarget t = this.frameStack.getJavaDebugTarget();
            ILaunchConfiguration lcfg = t.getLaunch().getLaunchConfiguration();
            try {
                IServer s = ServerUtil.getServer((ILaunchConfiguration)lcfg);
                IProject p = ServerLaunchUtils.getFirstWebModuleInServer((IServer)s);
                if (p != null) {
                    return JavaCore.create((IProject)p);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

