/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui;

import oracle.eclipse.tools.adf.debugger.lifecycle.AdfLifecyclePhaseBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.ActionBindingBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.BindingBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.IteratorBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.MethodBindingBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.TaskflowExecutableBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.ValueBindingBreakpoint;
import oracle.eclipse.tools.adf.debugger.taskflow.ActivityBreakpoint;
import oracle.eclipse.tools.adf.debugger.ui.AdfDebugUITools;
import oracle.eclipse.tools.adf.debugger.ui.AdfLifecyclePhase;
import oracle.eclipse.tools.adf.debugger.ui.AdfLifecyclePhaseEditorInput;
import oracle.eclipse.tools.adf.debugger.ui.OracleIcons;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIPlaceholderVariable;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class AdfDebugModelPresentation
extends JDIModelPresentation {
    public IEditorInput getEditorInput(Object element) {
        if (element instanceof AdfLifecyclePhaseBreakpoint) {
            AdfLifecyclePhase phase = new AdfLifecyclePhase();
            AdfLifecyclePhaseEditorInput input = new AdfLifecyclePhaseEditorInput(phase);
            return input;
        }
        if (element instanceof ActivityBreakpoint) {
            ActivityBreakpoint mb = (ActivityBreakpoint)element;
            IFile file = (IFile)mb.getMarker().getResource();
            FileEditorInput fin = new FileEditorInput(file);
            return fin;
        }
        if (element instanceof BindingBreakpoint) {
            BindingBreakpoint mb = (BindingBreakpoint)element;
            IFile file = (IFile)mb.getMarker().getResource();
            FileEditorInput fin = new FileEditorInput(file);
            return fin;
        }
        return super.getEditorInput(element);
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (element instanceof AdfLifecyclePhaseBreakpoint) {
            return "oracle.eclipse.tools.adf.debugger.ui.AdfLifecycleDiagramEditor";
        }
        if (element instanceof ActivityBreakpoint) {
            return "oracle.eclipse.tools.adf.controller.ui.editor.TaskFlowEditor";
        }
        if (element instanceof BindingBreakpoint) {
            return "oracle.eclipse.tools.adf.view.ui.editors.PageDefinitionEditor";
        }
        return super.getEditorId(input, element);
    }

    public Image getImage(Object element) {
        if (element instanceof AdfLifecyclePhaseBreakpoint) {
            return OracleIcons.getIcon("JSF_LIFECYCLE");
        }
        if (element instanceof ActivityBreakpoint) {
            return OracleIcons.getIcon("task-flow");
        }
        if (element instanceof BindingBreakpoint) {
            if (element instanceof MethodBindingBreakpoint) {
                return OracleIcons.getIcon("/breakpoint/method");
            }
            if (element instanceof ActionBindingBreakpoint) {
                return OracleIcons.getIcon("/breakpoint/actionbinding");
            }
            if (element instanceof ValueBindingBreakpoint) {
                return OracleIcons.getIcon("/breakpoint/attributebinding");
            }
            if (element instanceof IteratorBreakpoint) {
                return OracleIcons.getIcon("/breakpoint/iteratorbinding");
            }
            if (element instanceof TaskflowExecutableBreakpoint) {
                return OracleIcons.getIcon("/breakpoint/task_flow_binding");
            }
            return OracleIcons.getIcon("page-definition");
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof AdfLifecyclePhaseBreakpoint) {
            AdfLifecyclePhaseBreakpoint mb = (AdfLifecyclePhaseBreakpoint)element;
            return mb.getLabel();
        }
        if (element instanceof ActivityBreakpoint) {
            ActivityBreakpoint mb = (ActivityBreakpoint)element;
            return mb.getLabel();
        }
        if (element instanceof BindingBreakpoint) {
            BindingBreakpoint mb = (BindingBreakpoint)element;
            String label = mb.getLabel();
            if (AdfDebugUITools.isDebugMode()) {
                label = String.valueOf(label) + " {" + super.getText(element) + "}";
            }
            return label;
        }
        return super.getText(element);
    }

    public String getValueText(IJavaValue value) throws DebugException {
        String typeName;
        IJavaType javaType = value.getJavaType();
        if (javaType != null && value instanceof JDIObjectValue && JDIPlaceholderVariable.isLinkableValueType(typeName = javaType.getName())) {
            return JDIPlaceholderVariable.getLinkableFieldValue((JDIObjectValue)value);
        }
        return super.getValueText(value);
    }
}

