/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdt.debug.scope;

import java.text.MessageFormat;
import java.util.Iterator;
import oracle.adfdt.debug.common.DebuggeeDataDecorator;
import oracle.adfdt.debug.resources.AdfDebuggerArb;
import oracle.eclipse.tools.adf.debugger.ui.OracleIcons;
import oracle.ide.model.Element;
import oracle.ide.runner.DebuggeeData;

public class ScopeElement
extends DebuggeeDataDecorator {
    private static final String LONG_LABEL_SINGULAR = AdfDebuggerArb.SCOPE_LONG_LABEL_SINGULAR;
    private static final String LONG_LABEL_PLURAL = AdfDebuggerArb.SCOPE_LONG_LABEL_PLURAL;
    private String mLongLabel;
    private boolean mStructure;

    public ScopeElement(String scopeName, DebuggeeData scopeAsDebuggeeData, int scopeSize, boolean structure) {
        super(scopeName, OracleIcons.getIcon("FOLDER"), scopeAsDebuggeeData);
        this.mLongLabel = scopeSize == 1 ? MessageFormat.format(LONG_LABEL_SINGULAR, scopeSize) : MessageFormat.format(LONG_LABEL_PLURAL, scopeSize);
        this.mStructure = structure;
    }

    @Override
    public String getLongLabel() {
        return this.mLongLabel;
    }

    @Override
    public boolean mayHaveChildren() {
        if (this.mStructure) {
            return false;
        }
        return super.mayHaveChildren();
    }

    @Override
    public Iterator<Element> getChildren() {
        return NO_CHILDREN.iterator();
    }
}

