/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdt.debug.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.adf.debugger.ui.OracleIcons;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.runner.DebuggeeData;
import org.eclipse.swt.graphics.Image;

public class DebuggeeDataDecorator
implements Element,
Locatable {
    public static final List<Element> NO_CHILDREN = Collections.emptyList();
    private DebuggeeData mDebuggeeData;
    private String mShortLabel = null;
    private String mLongLabel = null;
    private String mToolTipText = null;
    private String mIconKey = null;
    private Image mIcon = null;
    private URL mUrl = null;
    private Attributes mAttributes = new ElementAttributes();

    public DebuggeeDataDecorator() {
    }

    public DebuggeeDataDecorator(DebuggeeData debuggeeData) {
        this.mDebuggeeData = debuggeeData;
        if (this.mDebuggeeData != null) {
            this.mShortLabel = this.mDebuggeeData.getShortLabel();
            this.mLongLabel = this.mDebuggeeData.getLongLabel();
            this.mToolTipText = this.mDebuggeeData.getToolTipText();
            this.mIcon = this.mDebuggeeData.getIcon();
        }
    }

    public DebuggeeDataDecorator(String shortLabel, DebuggeeData debuggeeData) {
        this.mShortLabel = shortLabel;
        this.mDebuggeeData = debuggeeData;
        if (this.mDebuggeeData != null) {
            this.mDebuggeeData.setDisplayName(shortLabel);
            this.mLongLabel = this.mDebuggeeData.getLongLabel();
            this.mToolTipText = this.mDebuggeeData.getToolTipText();
            this.mIcon = this.mDebuggeeData.getIcon();
        }
    }

    public DebuggeeDataDecorator(String shortLabel, String iconKey, DebuggeeData debuggeeData) {
        this.mShortLabel = shortLabel;
        this.mIconKey = iconKey;
        this.mDebuggeeData = debuggeeData;
        if (this.mDebuggeeData != null) {
            this.mDebuggeeData.setDisplayName(shortLabel);
            this.mLongLabel = this.mDebuggeeData.getLongLabel();
            this.mToolTipText = this.mDebuggeeData.getToolTipText();
        }
    }

    public DebuggeeDataDecorator(String shortLabel, Image icon, DebuggeeData debuggeeData) {
        this.mShortLabel = shortLabel;
        this.mIcon = icon;
        this.mDebuggeeData = debuggeeData;
        if (this.mDebuggeeData != null) {
            this.mDebuggeeData.setDisplayName(shortLabel);
            this.mLongLabel = this.mDebuggeeData.getLongLabel();
            this.mToolTipText = this.mDebuggeeData.getToolTipText();
        }
    }

    public void setDebuggeeData(DebuggeeData debuggeeData) {
        this.mDebuggeeData = debuggeeData;
        if (this.mDebuggeeData != null) {
            this.mShortLabel = this.mDebuggeeData.getShortLabel();
            this.mLongLabel = this.mDebuggeeData.getLongLabel();
            this.mToolTipText = this.mDebuggeeData.getToolTipText();
            this.mIcon = this.mDebuggeeData.getIcon();
        }
    }

    public DebuggeeData asDebuggeeData() {
        return this.mDebuggeeData;
    }

    @Override
    public String getShortLabel() {
        return this.mShortLabel;
    }

    @Override
    public String getLongLabel() {
        return this.mLongLabel;
    }

    @Override
    public String getToolTipText() {
        return this.mToolTipText;
    }

    @Override
    public Image getIcon() {
        if (this.mIconKey != null) {
            return OracleIcons.getIcon(this.mIconKey);
        }
        if (this.mIcon != null) {
            return this.mIcon;
        }
        return null;
    }

    @Override
    public URL getURL() {
        return this.mUrl;
    }

    @Override
    public void setURL(URL url) {
        this.mUrl = url;
    }

    @Override
    public Attributes getAttributes() {
        return this.mAttributes;
    }

    @Override
    public Iterator<Element> getChildren() {
        List<? extends DebuggeeData> debuggeeDataChildren;
        if (this.mDebuggeeData != null && (debuggeeDataChildren = this.mDebuggeeData.getChildren()) != null) {
            ArrayList<DebuggeeDataDecorator> children = new ArrayList<DebuggeeDataDecorator>(debuggeeDataChildren.size());
            for (DebuggeeData debuggeeData : debuggeeDataChildren) {
                children.add(new DebuggeeDataDecorator(debuggeeData));
            }
            return children.iterator();
        }
        return NO_CHILDREN.iterator();
    }

    @Override
    public Object getData() {
        return this.mDebuggeeData;
    }

    @Override
    public boolean mayHaveChildren() {
        if (this.mDebuggeeData != null) {
            return this.mDebuggeeData.mayHaveChildren();
        }
        return false;
    }

    public String getFullyQualifiedActualType() {
        if (this.mDebuggeeData != null) {
            return this.mDebuggeeData.getFullyQualifiedActualType();
        }
        return null;
    }

    public String getFullyQualifiedDeclaredType() {
        if (this.mDebuggeeData != null) {
            return this.mDebuggeeData.getFullyQualifiedDeclaredType();
        }
        return null;
    }

    public DebuggeeData.DataKind getKind() {
        if (this.mDebuggeeData != null) {
            return this.mDebuggeeData.getKind();
        }
        return null;
    }
}

