/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.dt.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.adf.share.dt.debug.AdfViewDebugUtils;
import oracle.adf.share.dt.debug.BaseView;
import oracle.adf.share.dt.debug.ComponentInfo;
import oracle.adf.share.dt.debug.JspViewContext;
import oracle.adf.share.dt.debug.RegionInfo;
import oracle.eclipse.tools.adf.debugger.ui.OracleIcons;
import oracle.ide.Context;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;
import org.eclipse.swt.graphics.Image;

public class JspView
extends BaseView {
    private boolean _attemptedToFindRoot = false;
    private ComponentInfo _root;
    private boolean _attemptedToRegions = false;
    private Collection<RegionInfo> _regions;
    private JspViewContext _context;

    public JspView() {
        this("JSP Document");
    }

    public JspView(String viewId) {
        super(viewId);
    }

    @Override
    public String getShortLabel() {
        return this.getViewId();
    }

    @Override
    public Image getIcon() {
        return OracleIcons.getIcon("JSP");
    }

    public Collection<RegionInfo> getContainedRegions(DebuggerEvaluator evaluator) {
        if (!this._attemptedToRegions) {
            this._attemptedToRegions = true;
            DebuggeeData regions = AdfViewDebugUtils.getRegionList(evaluator);
            if (regions == null) {
                return Collections.emptyList();
            }
            ArrayList<RegionInfo> ret = new ArrayList<RegionInfo>();
            List<? extends DebuggeeData> children = regions.getChildren();
            if (children != null) {
                for (DebuggeeData debuggeeData : children) {
                    ret.add(new RegionInfo(debuggeeData));
                }
            }
            this._regions = Collections.unmodifiableCollection(ret);
        }
        return this._regions;
    }

    @Override
    public ComponentInfo getViewRoot(DebuggerEvaluator evaluator) {
        if (!this._attemptedToFindRoot) {
            this._attemptedToFindRoot = true;
            DebuggeeData viewRoot = AdfViewDebugUtils.getViewRoot(evaluator);
            if (viewRoot == null) {
                return null;
            }
            this._root = new ComponentInfo(viewRoot);
        }
        return this._root;
    }

    @Override
    public JspViewContext getJspViewContext(Context ideContext) {
        if (this._context == null) {
            this._context = new JspViewContext(ideContext);
        }
        return this._context;
    }
}

