/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.dt.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.adf.share.dt.debug.PropertyInfo;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import oracle.ide.runner.DebuggeeData;

public class ComponentInfo {
    private DebuggeeData _component;
    private DebuggeeData _instance;
    private String _componentClass;
    private String _rendererType;
    private List<ComponentInfo> _children;
    private List<ComponentInfo> _specialChildren;
    private List<PropertyInfo> _properties;
    private String _displayHint;
    private boolean _containsPageTemplate;
    private DebuggeeData _converter;
    private List<? extends DebuggeeData> _validators;

    public ComponentInfo(DebuggeeData component) {
        this._component = component;
    }

    public String getComponentClass() {
        if (this._component != null) {
            this._init();
        }
        return this._componentClass;
    }

    public String getRendererType() {
        if (this._component != null) {
            this._init();
        }
        return this._rendererType;
    }

    public List<ComponentInfo> getComponents() {
        if (this._component != null) {
            this._init();
        }
        return this._children;
    }

    public List<ComponentInfo> getSpecialComponents() {
        if (this._component != null) {
            this._init();
        }
        return this._specialChildren;
    }

    public List<PropertyInfo> getProperties() {
        if (this._component != null) {
            this._init();
        }
        return this._properties;
    }

    public DebuggeeData getConverter() {
        return this._converter;
    }

    public List<? extends DebuggeeData> getValidators() {
        return this._validators;
    }

    public DebuggeeData getComponent() {
        if (this._component != null) {
            this._init();
        }
        return this._instance;
    }

    public String getDisplayHint() {
        if (this._component != null) {
            this._init();
        }
        return this._displayHint;
    }

    public boolean containsPageTemplate() {
        if (this._component != null) {
            this._init();
        }
        return this._containsPageTemplate;
    }

    private void _init() {
        for (DebuggeeData debuggeeData : this._component.getDeclaredFields()) {
            ArrayList<ComponentInfo> children;
            List<? extends DebuggeeData> fChildren;
            String name = debuggeeData.getShortLabel();
            if ("componentClass".equals(name)) {
                this._componentClass = DebuggerEvaluatorUtils.evaluateString(debuggeeData);
                continue;
            }
            if ("rendererType".equals(name)) {
                this._rendererType = DebuggerEvaluatorUtils.evaluateString(debuggeeData);
                continue;
            }
            if ("children".equals(name)) {
                fChildren = debuggeeData.getChildren();
                if (fChildren != null) {
                    children = new ArrayList<ComponentInfo>();
                    for (DebuggeeData debuggeeData2 : fChildren) {
                        children.add(new ComponentInfo(debuggeeData2));
                    }
                    this._children = Collections.unmodifiableList(children);
                    continue;
                }
                this._children = Collections.emptyList();
                continue;
            }
            if ("specialChildren".equals(name)) {
                fChildren = debuggeeData.getChildren();
                if (fChildren != null) {
                    children = new ArrayList();
                    for (DebuggeeData debuggeeData3 : fChildren) {
                        children.add(new ComponentInfo(debuggeeData3));
                    }
                    this._specialChildren = Collections.unmodifiableList(children);
                    continue;
                }
                this._specialChildren = Collections.emptyList();
                continue;
            }
            if ("properties".equals(name)) {
                ArrayList<PropertyInfo> properties = new ArrayList<PropertyInfo>();
                List<? extends DebuggeeData> fProperties = debuggeeData.getChildren();
                if (fProperties != null) {
                    for (DebuggeeData debuggeeData4 : fProperties) {
                        properties.add(new PropertyInfo(debuggeeData4));
                    }
                }
                this._properties = Collections.unmodifiableList(properties);
                continue;
            }
            if ("component".equals(name)) {
                this._instance = debuggeeData;
                continue;
            }
            if ("converter".equals(name)) {
                this._converter = debuggeeData;
                continue;
            }
            if ("validators".equals(name)) {
                if (debuggeeData != null) {
                    this._validators = debuggeeData.getChildren();
                    continue;
                }
                this._validators = Collections.emptyList();
                continue;
            }
            if ("displayHint".equals(name)) {
                this._displayHint = DebuggerEvaluatorUtils.evaluateString(debuggeeData);
                continue;
            }
            if (!"containsPageTemplate".equals(name)) continue;
            this._containsPageTemplate = DebuggerEvaluatorUtils.evaluateBoolean(debuggeeData);
        }
        this._component = null;
    }
}

