/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.dt.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.adf.share.dt.debug.ELEvaluationContext;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;

public class AdfViewDebugUtils {
    private static final String REGISTER_DEBUGUTIL0 = "oracle.adf.share.common.ClassUtils.forName(\"oracle.adf.model.BindingContext\")";
    private static final String REGISTER_DEBUGUTIL1 = "oracle.adf.share.common.ClassUtils.forName(\"oracle.adfinternal.controller.debug.DebugFacadeImpl\")";
    private static final String REGISTER_DEBUGUTIL2 = "oracle.adf.share.common.ClassUtils.forName(\"oracle.adfinternal.view.faces.debugger.DebuggerUtils\")";
    private static final String REGISTER_DEBUGUTIL3 = "oracle.adf.share.common.ClassUtils.forName(\"oracle.adfinternal.view.faces.debugger.DebuggerUtils$RegionInfo\")";
    private static final String REGISTER_DEBUGUTIL4 = "oracle.adf.share.common.ClassUtils.forName(\"oracle.adfinternal.view.faces.debugger.DebuggerUtils$ComponentInfo\")";
    private static final String REGISTER_DEBUGUTIL5 = "oracle.adf.share.common.ClassUtils.forName(\"oracle.adfinternal.controller.debug.ViewPortContextDebugDetail\")";
    private static final String REGISTER_DEBUGUTIL6 = "oracle.adf.share.common.ClassUtils.forName(\"oracle.adfinternal.controller.debug.CurrentScopesDebugDetail\")";
    private static final String REGISTER_DEBUGUTIL7 = "oracle.adf.share.common.ClassUtils.forName(\"oracle.adfinternal.model.debug.DebuggeeUtils\")";
    private static final String REGISTER_DEBUGUTIL8 = "oracle.adf.share.common.ClassUtils.forName(\"oracle.adfinternal.model.debug.AdfDebugDetailContext\")";

    public static void ensureUtilClassLoaded(DebuggerEvaluator evaluator) {
        ArrayList<String> expressions = new ArrayList<String>();
        expressions.add(REGISTER_DEBUGUTIL0);
        expressions.add(REGISTER_DEBUGUTIL1);
        expressions.add(REGISTER_DEBUGUTIL2);
        expressions.add(REGISTER_DEBUGUTIL3);
        expressions.add(REGISTER_DEBUGUTIL4);
        expressions.add(REGISTER_DEBUGUTIL5);
        expressions.add(REGISTER_DEBUGUTIL6);
        expressions.add(REGISTER_DEBUGUTIL7);
        expressions.add(REGISTER_DEBUGUTIL8);
        evaluator.evaluate(expressions, null);
    }

    public static DebuggeeData evaluateExpression(DebuggerEvaluator evaluator, ELEvaluationContext eeContext, String expression) {
        AdfViewDebugUtils.ensureUtilClassLoaded(evaluator);
        String clientId = eeContext != null ? eeContext.getContextualClientId() : null;
        String evalClientId = clientId != null ? "\"" + clientId + "\"" : "null";
        String toCall = String.format("oracle.adfinternal.view.faces.debugger.DebuggerUtils.evaluate(%s, \"%s\")", evalClientId, expression.trim());
        return evaluator.evaluate(toCall, null);
    }

    public static List<String> getRootObjectNames(DebuggerEvaluator evaluator) {
        AdfViewDebugUtils.ensureUtilClassLoaded(evaluator);
        DebuggeeData results = evaluator.evaluate("oracle.adfinternal.view.faces.debugger.DebuggerUtils.getRootObjectNames()", null);
        if (results == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (DebuggeeData debuggeeData : results.getChildren()) {
            String value = DebuggerEvaluatorUtils.evaluateString(debuggeeData);
            if (value == null || "".equals(value)) continue;
            ret.add(value);
        }
        return ret;
    }

    public static List<String> peekIntoChildren(DebuggerEvaluator evaluator, ELEvaluationContext eeContext, String expression) {
        AdfViewDebugUtils.ensureUtilClassLoaded(evaluator);
        String clientId = eeContext != null ? eeContext.getContextualClientId() : null;
        String evalClientId = clientId != null ? "\"" + clientId + "\"" : "null";
        String toCall = String.format("oracle.adfinternal.view.faces.debugger.DebuggerUtils.peekIntoChildren(%s, \"%s\")", evalClientId, expression.trim());
        DebuggeeData results = evaluator.evaluate(toCall, null);
        if (results == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (DebuggeeData debuggeeData : results.getChildren()) {
            String value = DebuggerEvaluatorUtils.evaluateString(debuggeeData);
            if (value == null || "".equals(value)) continue;
            ret.add(value);
        }
        return ret;
    }

    public static DebuggeeData getViewRoot(DebuggerEvaluator evaluator) {
        AdfViewDebugUtils.ensureUtilClassLoaded(evaluator);
        return evaluator.evaluate("oracle.adfinternal.view.faces.debugger.DebuggerUtils.getViewRoot()", null);
    }

    public static DebuggeeData getRegionList(DebuggerEvaluator evaluator) {
        AdfViewDebugUtils.ensureUtilClassLoaded(evaluator);
        return evaluator.evaluate("oracle.adfinternal.view.faces.debugger.DebuggerUtils.getRegions()", null);
    }
}

