/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.dt.debug;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import oracle.adf.share.dt.debug.AdfContextDebugArb;
import oracle.adf.share.dt.debug.AdfViewDebugUtils;
import oracle.adf.share.dt.debug.AdfcDebugArb;
import oracle.adfdt.debug.common.DeclaredFieldsElementFactory;
import oracle.adfdt.debug.scope.ScopeElement;
import oracle.adfdt.debug.scope.ScopeElementFactory;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;

public class AdfContextScopesUtils {
    private static final String ADF_CONTEXT_GET_CURRENT = "oracle.adf.share.ADFContext.getCurrent()";
    private static final String ADF_CONTEXT_GET_REQUEST_SCOPE = "getRequestScope()";
    private static final String ADF_CONTEXT_GET_VIEW_SCOPE = "getViewScope()";
    private static final String ADF_CONTEXT_GET_SESSION_SCOPE = "getSessionScope()";
    private static final String ADF_CONTEXT_GET_APPLICATION_SCOPE = "getApplicationScope()";
    private static final List<String> ADF_CONTEXT_GET_SCOPES = Arrays.asList("getRequestScope()", "getViewScope()", "getSessionScope()", "getApplicationScope()");
    private static final String GET_CURRENT_SCOPES_DEBUG_DETAIL = "oracle.adfinternal.controller.debug.DebugFacadeImpl.getCurrentScopesDebugDetail()";
    private static final String PAGE_FLOW_SCOPE_FIELD = "pageFlowScope";
    private static final String REQUEST_SCOPE_SHORT_LABEL = AdfContextDebugArb.REQUEST_SCOPE_SHORT_LABEL;
    private static final String SESSION_SCOPE_SHORT_LABEL = AdfContextDebugArb.SESSION_SCOPE_SHORT_LABEL;
    private static final String VIEW_SCOPE_SHORT_LABEL = AdfContextDebugArb.VIEW_SCOPE_SHORT_LABEL;
    private static final String APPLICATION_SCOPE_SHORT_LABEL = AdfContextDebugArb.APPLICATION_SCOPE_SHORT_LABEL;
    private static final String PAGE_FLOW_SCOPE_SHORT_LABEL = AdfcDebugArb.PAGE_FLOW_SCOPE_SHORT_LABEL;

    private AdfContextScopesUtils() {
    }

    public static List<Element> getScopeElements(DebuggerEvaluator evaluator, boolean structure) {
        ScopeElement sessionScopeElement;
        AdfViewDebugUtils.ensureUtilClassLoaded(evaluator);
        LinkedList<Element> scopeElements = new LinkedList<Element>();
        DebuggeeData adfContextAsDebuggeeData = evaluator.evaluate(ADF_CONTEXT_GET_CURRENT, null);
        List<DebuggeeData> adfContextScopesAsDebuggeeData = evaluator.evaluate(ADF_CONTEXT_GET_SCOPES, adfContextAsDebuggeeData);
        DebuggeeData requestScopeAsDebuggeeData = adfContextScopesAsDebuggeeData.get(0);
        DebuggeeData viewScopeAsDebuggeeData = adfContextScopesAsDebuggeeData.get(1);
        DebuggeeData sessionScopeAsDebuggeeData = adfContextScopesAsDebuggeeData.get(2);
        DebuggeeData applicationScopeAsDebuggeeData = adfContextScopesAsDebuggeeData.get(3);
        DebuggeeData currentScopesDebugDetailAsDebuggeeData = evaluator.evaluate(GET_CURRENT_SCOPES_DEBUG_DETAIL, null);
        if (currentScopesDebugDetailAsDebuggeeData != null) {
            DeclaredFieldsElementFactory declaredFieldsElementFactory = new DeclaredFieldsElementFactory();
            declaredFieldsElementFactory.putElementFactory(PAGE_FLOW_SCOPE_FIELD, new ScopeElementFactory(PAGE_FLOW_SCOPE_SHORT_LABEL, structure));
            List<Element> pageScopeElements = declaredFieldsElementFactory.createElements(new Context(), evaluator, currentScopesDebugDetailAsDebuggeeData);
            scopeElements.addAll(pageScopeElements);
        }
        if (requestScopeAsDebuggeeData != null) {
            int requestScopeSize = DebuggerEvaluatorUtils.evaluateCollectionSize(evaluator, requestScopeAsDebuggeeData);
            ScopeElement requestScopeElement = new ScopeElement(REQUEST_SCOPE_SHORT_LABEL, requestScopeAsDebuggeeData, requestScopeSize, structure);
            scopeElements.add(requestScopeElement);
        }
        if (sessionScopeAsDebuggeeData != null) {
            int sessionScopeSize = DebuggerEvaluatorUtils.evaluateCollectionSize(evaluator, sessionScopeAsDebuggeeData);
            sessionScopeElement = new ScopeElement(SESSION_SCOPE_SHORT_LABEL, sessionScopeAsDebuggeeData, sessionScopeSize, structure);
            scopeElements.add(sessionScopeElement);
        }
        if (viewScopeAsDebuggeeData != null) {
            int viewScopeSize = DebuggerEvaluatorUtils.evaluateCollectionSize(evaluator, viewScopeAsDebuggeeData);
            sessionScopeElement = new ScopeElement(VIEW_SCOPE_SHORT_LABEL, viewScopeAsDebuggeeData, viewScopeSize, structure);
            scopeElements.add(sessionScopeElement);
        }
        if (applicationScopeAsDebuggeeData != null) {
            int applicationScopeSize = DebuggerEvaluatorUtils.evaluateCollectionSize(evaluator, applicationScopeAsDebuggeeData);
            ScopeElement applicationScopeElement = new ScopeElement(APPLICATION_SCOPE_SHORT_LABEL, applicationScopeAsDebuggeeData, applicationScopeSize, structure);
            scopeElements.add(applicationScopeElement);
        }
        return scopeElements;
    }
}

