/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.tooltips.presenter;

import java.lang.ref.WeakReference;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.core.tooltips.presenter.AbstractTooltipInformationPresenter;
import org.python.pydev.core.tooltips.presenter.InformationPresenterControlManager;

public class InformationPresenterHelpers {

    public static final class PyInformationControl
    extends DefaultInformationControl
    implements IInformationControlExtension3 {
        public PyInformationControl(Shell parent, String statusFieldText, DefaultInformationControl.IInformationPresenter presenter) {
            super(parent, statusFieldText, presenter);
        }

        public Rectangle getShellTooltipBounds() {
            return this.getShell().getBounds();
        }
    }

    public static class TooltipInformationControlCreator
    implements IInformationControlCreator {
        private DefaultInformationControl.IInformationPresenter presenter;
        private WeakReference<InformationPresenterControlManager> informationPresenterControlManager;

        public void setInformationPresenterControlManager(InformationPresenterControlManager informationPresenterControlManager) {
            this.informationPresenterControlManager = new WeakReference<InformationPresenterControlManager>(informationPresenterControlManager);
        }

        public TooltipInformationControlCreator(DefaultInformationControl.IInformationPresenter presenter) {
            if (presenter == null) {
                presenter = new AbstractTooltipInformationPresenter(){

                    protected void onUpdatePresentation(String hoverInfo, TextPresentation presentation) {
                    }

                    protected void onHandleClick(Object data) {
                    }
                };
            }
            this.presenter = presenter;
        }

        public IInformationControl createInformationControl(Shell parent) {
            InformationPresenterControlManager m;
            String tooltipAffordanceString = null;
            if (this.informationPresenterControlManager != null && (m = (InformationPresenterControlManager)this.informationPresenterControlManager.get()) != null) {
                tooltipAffordanceString = m.getTooltipAffordanceString();
            }
            PyInformationControl tooltip = new PyInformationControl(null, tooltipAffordanceString, this.presenter);
            return tooltip;
        }
    }
}

