/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.path_watch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import name.pachler.nio.file.ClosedWatchServiceException;
import name.pachler.nio.file.FileSystems;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.Paths;
import name.pachler.nio.file.StandardWatchEventKind;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.WatchKey;
import name.pachler.nio.file.WatchService;
import name.pachler.nio.file.ext.ExtendedWatchEventKind;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.core.ListenerList;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.path_watch.EventsStackerRunnable;
import org.python.pydev.core.path_watch.IFilesystemChangesListener;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathWatch {
    private WatchService watchService;
    public static FastStringBuffer log;
    private Map<Path, EventsStackerRunnable> pathToStacker = new HashMap<Path, EventsStackerRunnable>();
    private final Object keyToPathLock = new Object();
    private Map<WatchKey, Path> keyToPath = new HashMap<WatchKey, Path>();
    private final Object invalidPathsLock = new Object();
    private volatile Set<EventsStackerRunnable> invalidPaths = new HashSet<EventsStackerRunnable>();
    private final PollThread pollThread;
    private final Object lock = new Object();
    private volatile List<Runnable> runnables = new ArrayList<Runnable>();
    private final Job jobRunRunnables = new Job("PathWatch notifier"){

        protected IStatus run(IProgressMonitor monitor) {
            List curr = PathWatch.this.runnables;
            PathWatch.this.runnables = new ArrayList();
            for (Runnable runnable : curr) {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
            return Status.OK_STATUS;
        }
    };
    public static int RECHECK_INVALID_PATHS_EACH;
    private final Job invalidPathsRestorer = new Job("Invalid paths restorer"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Object object = PathWatch.this.invalidPathsLock;
            synchronized (object) {
                if (log != null) {
                    log.append('.');
                }
                HashSet<EventsStackerRunnable> remove = new HashSet<EventsStackerRunnable>();
                for (EventsStackerRunnable r : PathWatch.this.invalidPaths) {
                    IFilesystemChangesListener[] listeners = r.list.getListeners();
                    if (listeners.length == 0) {
                        if (log != null) {
                            log.append("Removing stacker from invalid list (because it has no listeners): ").appendObject((Object)r).append('\n');
                        }
                        remove.add(r);
                        continue;
                    }
                    File f = new File(r.watchedPath.toString());
                    if (!f.exists()) continue;
                    IFilesystemChangesListener[] iFilesystemChangesListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFilesystemChangesListener listener = iFilesystemChangesListenerArray[n2];
                        listener.added(f);
                        ++n2;
                    }
                    try {
                        WatchKey key;
                        r.key = key = r.watchedPath.register(PathWatch.this.watchService, new WatchEvent.Kind[]{StandardWatchEventKind.ENTRY_CREATE, StandardWatchEventKind.ENTRY_DELETE, StandardWatchEventKind.ENTRY_MODIFY, StandardWatchEventKind.OVERFLOW, ExtendedWatchEventKind.KEY_INVALID});
                        Object object2 = PathWatch.this.keyToPathLock;
                        synchronized (object2) {
                            PathWatch.this.keyToPath.put(key, r.watchedPath);
                        }
                        if (log != null) {
                            log.append("Removing stacker from invalid list because it became valid again: ").appendObject((Object)r).append('\n');
                        }
                        remove.add(r);
                    }
                    catch (UnsupportedOperationException uox) {
                        Log.log(uox);
                    }
                    catch (IOException iOException) {
                        if (log == null) continue;
                        log.append("IOException when trying to make valid: " + r.watchedPath);
                    }
                    catch (Throwable e) {
                        Log.log(e);
                    }
                }
                PathWatch.this.invalidPaths.removeAll(remove);
                int size = PathWatch.this.invalidPaths.size();
                if (log != null && size < 0) {
                    log.append("\nBUG BUG BUG: Size: ").append(size).append('\n');
                }
                if (size > 0) {
                    this.schedule(RECHECK_INVALID_PATHS_EACH);
                    if (log != null) {
                        log.append("!");
                    }
                } else if (log != null) {
                    log.append("NOT rescheduling; size=").append(size).append(";invalidPaths=").appendObject((Object)PathWatch.this.invalidPaths).append('\n');
                }
            }
            return Status.OK_STATUS;
        }
    };
    public static int TIME_BEFORE_NOTIFY;
    private static PathWatch singleton;

    static {
        RECHECK_INVALID_PATHS_EACH = 4000;
        TIME_BEFORE_NOTIFY = 250;
        singleton = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<EventsStackerRunnable> getInvalidPaths() {
        Object object = this.invalidPathsLock;
        synchronized (object) {
            return new HashSet<EventsStackerRunnable>(this.invalidPaths);
        }
    }

    private PathWatch() {
        this.watchService = FileSystems.getDefault().newWatchService();
        this.pollThread = new PollThread();
        this.pollThread.start();
    }

    public static PathWatch get() {
        if (singleton == null) {
            singleton = new PathWatch();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTrack(File path, IFilesystemChangesListener listener) {
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)listener);
        Path watchedPath = Paths.get((String)FileUtils.getFileAbsolutePath((File)path));
        if (log != null) {
            log.append("STOP Track: ").appendObject((Object)path).append("Listener: ").appendObject((Object)listener).append('\n');
        }
        Object object = this.lock;
        synchronized (object) {
            EventsStackerRunnable stacker = this.pathToStacker.get(watchedPath);
            if (stacker != null && stacker.list != null) {
                ListenerList<IFilesystemChangesListener> list = stacker.list;
                list.remove(listener);
                if (list.getListeners().length == 0) {
                    this.pathToStacker.remove(watchedPath);
                    Object object2 = this.keyToPathLock;
                    synchronized (object2) {
                        this.keyToPath.remove(stacker.key);
                    }
                    object2 = this.invalidPathsLock;
                    synchronized (object2) {
                        if (log != null) {
                            log.append("Remove from invalid paths (no listeners): ").appendObject((Object)stacker).append('\n');
                        }
                        this.invalidPaths.remove(stacker);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(File path, IFilesystemChangesListener listener) {
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)listener);
        Path watchedPath = Paths.get((String)FileUtils.getFileAbsolutePath((File)path));
        Object object = this.lock;
        synchronized (object) {
            EventsStackerRunnable stacker = this.pathToStacker.get(watchedPath);
            if (stacker != null) {
                stacker.list.add(listener);
                return;
            }
            if (log != null) {
                log.append("Track: ").appendObject((Object)path).append("Listener: ").appendObject((Object)listener).append('\n');
            }
            boolean add = true;
            WatchKey key = null;
            try {
                key = watchedPath.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKind.ENTRY_CREATE, StandardWatchEventKind.ENTRY_DELETE, StandardWatchEventKind.ENTRY_MODIFY, StandardWatchEventKind.OVERFLOW, ExtendedWatchEventKind.KEY_INVALID});
            }
            catch (UnsupportedOperationException uox) {
                if (log != null) {
                    log.append("UnsupportedOperationException: ").appendObject((Object)uox).append('\n');
                }
                add = false;
                Log.log(uox);
            }
            catch (IOException iOException) {
            }
            catch (Throwable e) {
                if (log != null) {
                    log.append("Throwable: ").appendObject((Object)e).append('\n');
                }
                add = false;
                Log.log(e);
            }
            if (add) {
                if (stacker == null) {
                    stacker = new EventsStackerRunnable(key, watchedPath, new ListenerList<IFilesystemChangesListener>(IFilesystemChangesListener.class));
                    this.pathToStacker.put(watchedPath, stacker);
                }
                stacker.list.add(listener);
                if (key != null) {
                    Object object2 = this.keyToPathLock;
                    synchronized (object2) {
                        this.keyToPath.put(key, watchedPath);
                    }
                } else {
                    this.addInvalidPath(stacker);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInvalidPath(EventsStackerRunnable stacker) {
        if (log != null) {
            log.append("addInvalidPath: ").appendObject((Object)stacker).append('\n');
        }
        Object object = this.invalidPathsLock;
        synchronized (object) {
            this.invalidPaths.add(stacker);
        }
        this.invalidPathsRestorer.schedule((long)RECHECK_INVALID_PATHS_EACH);
    }

    private class PollThread
    extends Thread {
        private PollThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                WatchKey signalledKey;
                try {
                    signalledKey = PathWatch.this.watchService.take();
                }
                catch (InterruptedException interruptedException) {
                    if (log == null) continue;
                    log.append("Interrupted\n");
                    continue;
                }
                catch (ClosedWatchServiceException closedWatchServiceException) {
                    System.out.println("watch service closed, terminating.");
                    break;
                }
                Object object = PathWatch.this.lock;
                synchronized (object) {
                    Path watchedPath;
                    Object object2 = PathWatch.this.keyToPathLock;
                    synchronized (object2) {
                        watchedPath = (Path)PathWatch.this.keyToPath.get(signalledKey);
                    }
                    if (watchedPath == null) {
                        continue;
                    }
                    List list = signalledKey.pollEvents();
                    EventsStackerRunnable stacker = (EventsStackerRunnable)PathWatch.this.pathToStacker.get(watchedPath);
                    if (stacker == null) {
                        if (log != null) {
                            log.append("Stacker for: ").appendObject((Object)watchedPath).append("is null\n");
                        }
                        continue;
                    }
                    PathWatch.this.runnables.add(stacker);
                    for (WatchEvent e : list) {
                        Object object3;
                        Path context = (Path)e.context();
                        Path resolve = watchedPath.resolve(context);
                        File file = new File(resolve.toString());
                        WatchEvent.Kind kind = e.kind();
                        if (log != null) {
                            log.append("Event: ").appendObject((Object)e).append('\n');
                        }
                        if (kind == StandardWatchEventKind.OVERFLOW) {
                            if (!file.exists()) {
                                object3 = PathWatch.this.keyToPathLock;
                                synchronized (object3) {
                                    PathWatch.this.keyToPath.remove(signalledKey);
                                }
                                stacker.key = null;
                                PathWatch.this.addInvalidPath(stacker);
                                stacker.removed(file);
                            } else {
                                signalledKey.reset();
                                if (log != null) {
                                    log.append("Key reset to hear changes");
                                }
                            }
                            stacker.overflow(file);
                            continue;
                        }
                        if (kind == StandardWatchEventKind.ENTRY_CREATE || kind == StandardWatchEventKind.ENTRY_MODIFY) {
                            signalledKey.reset();
                            if (log != null) {
                                log.append("Key reset to hear changes");
                            }
                            stacker.added(file);
                            continue;
                        }
                        if (kind == StandardWatchEventKind.ENTRY_DELETE) {
                            signalledKey.reset();
                            if (log != null) {
                                log.append("Key reset to hear changes");
                            }
                            stacker.removed(file);
                            continue;
                        }
                        if (kind != ExtendedWatchEventKind.KEY_INVALID) continue;
                        object3 = PathWatch.this.keyToPathLock;
                        synchronized (object3) {
                            PathWatch.this.keyToPath.remove(signalledKey);
                        }
                        stacker.key = null;
                        PathWatch.this.addInvalidPath(stacker);
                        stacker.removed(file);
                    }
                }
                if (PathWatch.this.runnables.size() <= 0) continue;
                PathWatch.this.jobRunRunnables.schedule((long)TIME_BEFORE_NOTIFY);
            }
        }
    }
}

