/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import org.python.pydev.core.ObjectsPool;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.string.Base64Coder;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils
extends org.python.pydev.shared_core.string.StringUtils {
    public static final String EMPTY = "";
    private static final boolean DEBUG = false;
    private static final int STATE_LOWER = 0;
    private static final int STATE_UPPER = 1;
    private static final int STATE_NUMBER = 2;
    public static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    public static final char[] CLOSING_BRACKETS = new char[]{'}', ')', ']'};

    private StringUtils() {
    }

    public static int lastIndexOf(String string, String regex) {
        Pattern pat;
        int index = -1;
        if (string == null || regex == null || string.length() == 0 || regex.length() == 0) {
            return index;
        }
        try {
            pat = Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return index;
        }
        int len = string.length();
        int i = len - 1;
        char c = '\u0000';
        Matcher mat = null;
        while (i >= 0) {
            c = string.charAt(i);
            mat = pat.matcher(String.valueOf(c));
            if (mat.matches()) {
                index = i;
                break;
            }
            --i;
        }
        return index;
    }

    public static int indexOf(String string, char character, boolean ignoreInStringLiteral) {
        if (string == null || character < '\u0000' || string.length() == 0) {
            return -1;
        }
        int index = string.indexOf(character);
        if (-1 == index) {
            return index;
        }
        if (ignoreInStringLiteral) {
            int len = string.length();
            boolean inString = false;
            char nextc = '\u0000';
            char c = '\u0000';
            int i = -1;
            try {
                while (i < len) {
                    c = string.charAt(++i);
                    if (i + 1 < len) {
                        nextc = string.charAt(i + 1);
                    }
                    if ('\\' == c) {
                        ++i;
                        continue;
                    }
                    if (!inString && character == c) {
                        index = i;
                        break;
                    }
                    if ('\"' != c && '\'' != c) continue;
                    if ('\"' == nextc || '\'' == nextc) {
                        ++i;
                        continue;
                    }
                    inString = !inString;
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                index = -1;
            }
        }
        return index;
    }

    public static String findSubstring(String string, char character, boolean ignoreInStringLiteral) {
        String result = null;
        int index = StringUtils.indexOf(string, character, ignoreInStringLiteral);
        if (index >= 0) {
            result = string.substring(index + 1);
        }
        return result;
    }

    public static <T> String joinIterable(String delimiter, Iterable<T> objs) throws IllegalArgumentException {
        if (objs == null) {
            throw new IllegalArgumentException("objs can't be null!");
        }
        if (delimiter == null) {
            throw new IllegalArgumentException("delimiter can't be null");
        }
        Iterator<T> iter = objs.iterator();
        if (!iter.hasNext()) {
            return EMPTY;
        }
        String nxt = String.valueOf(iter.next());
        FastStringBuffer buffer = new FastStringBuffer(String.valueOf(nxt), nxt.length());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(String.valueOf(iter.next()));
        }
        return buffer.toString();
    }

    public static String repeatString(String str, int times) {
        String s = String.valueOf(str);
        if (s.length() == 0 || times <= 0) {
            return EMPTY;
        }
        FastStringBuffer buffer = new FastStringBuffer();
        int i = 0;
        while (i < times) {
            buffer.append(s);
            ++i;
        }
        return buffer.toString();
    }

    public static Boolean isEmpty(String str) {
        if (str.length() == 0) {
            return true;
        }
        return false;
    }

    public static int countPercS(String str) {
        int j = 0;
        int len = str.length();
        int i = 0;
        while (i < len) {
            char nextC;
            char c = str.charAt(i);
            if (c == '%' && i + 1 < len && (nextC = str.charAt(i + 1)) == 's') {
                ++j;
                ++i;
            }
            ++i;
        }
        return j;
    }

    public static String rightTrim(String input) {
        int len = input.length();
        int st = 0;
        int off = 0;
        while (st < len && input.charAt(off + len - 1) <= ' ') {
            --len;
        }
        return input.substring(0, len);
    }

    public static String leftTrim(String input) {
        int len = input.length();
        int off = 0;
        while (off < len && input.charAt(off) <= ' ') {
            ++off;
        }
        return input.substring(off, len);
    }

    public static String stripExtension(String input) {
        return StringUtils.stripFromRigthCharOnwards(input, '.');
    }

    public static int rFind(String input, char ch) {
        int len = input.length();
        int st = 0;
        int off = 0;
        while (st < len && input.charAt(off + len - 1) != ch) {
            --len;
        }
        return --len;
    }

    private static String stripFromRigthCharOnwards(String input, char ch) {
        int len = StringUtils.rFind(input, ch);
        if (len == -1) {
            return input;
        }
        return input.substring(0, len);
    }

    public static String stripFromLastSlash(String input) {
        return StringUtils.stripFromRigthCharOnwards(input, '/');
    }

    public static String rightTrim(String input, char charToTrim) {
        int len = input.length();
        int st = 0;
        int off = 0;
        while (st < len && input.charAt(off + len - 1) == charToTrim) {
            --len;
        }
        return input.substring(0, len);
    }

    public static String leftAndRightTrim(String input, char charToTrim) {
        return StringUtils.rightTrim(StringUtils.leftTrim(input, charToTrim), charToTrim);
    }

    public static String leftTrim(String input, char charToTrim) {
        int len = input.length();
        int off = 0;
        while (off < len && input.charAt(off) == charToTrim) {
            ++off;
        }
        return input.substring(off, len);
    }

    public static String replaceAllSlashes(String string) {
        int len = string.length();
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == '\\') {
                char[] ds = string.toCharArray();
                ds[i] = 47;
                int j = i;
                while (j < len) {
                    if (ds[j] == '\\') {
                        ds[j] = 47;
                    }
                    ++j;
                }
                return new String(ds);
            }
            ++i;
        }
        return string;
    }

    public static String fixWhitespaceColumnsToLeftFromDocstring(String docString, String indentationToAdd) {
        char c;
        FastStringBuffer buf = new FastStringBuffer();
        List splitted = StringUtils.splitInLines((String)docString);
        int i = 0;
        while (i < splitted.size()) {
            String initialString = (String)splitted.get(i);
            if (i == 0) {
                buf.append(initialString);
            } else {
                String string = StringUtils.leftTrim(initialString);
                buf.append(indentationToAdd);
                if (string.length() > 0) {
                    buf.append(string);
                } else {
                    int length = initialString.length();
                    if (length > 0) {
                        char c2;
                        if (length > 1 && ((c2 = initialString.charAt(length - 2)) == '\n' || c2 == '\r')) {
                            buf.append(c2);
                        }
                        if ((c2 = initialString.charAt(length - 1)) == '\n' || c2 == '\r') {
                            buf.append(c2);
                        }
                    }
                }
            }
            ++i;
        }
        if (buf.length() > 0 && ((c = buf.lastChar()) == '\r' || c == '\n')) {
            buf.append(indentationToAdd);
        }
        return buf.toString();
    }

    public static String removeWhitespaceColumnsToLeft(String hoverInfo) {
        FastStringBuffer buf = new FastStringBuffer();
        int firstCharPosition = Integer.MAX_VALUE;
        List splitted = StringUtils.splitInLines((String)hoverInfo);
        for (String line : splitted) {
            if (line.trim().length() <= 0) continue;
            int found = PySelection.getFirstCharPosition((String)line);
            firstCharPosition = Math.min(found, firstCharPosition);
        }
        if (firstCharPosition != Integer.MAX_VALUE) {
            for (String line : splitted) {
                if (line.length() <= firstCharPosition) continue;
                buf.append(line.substring(firstCharPosition));
            }
            return buf.toString();
        }
        return hoverInfo;
    }

    public static String removeWhitespaceColumnsToLeftAndApplyIndent(String code, String indent, boolean indentCommentLinesAt0Pos) {
        FastStringBuffer buf = new FastStringBuffer();
        int firstCharPosition = Integer.MAX_VALUE;
        List splitted = StringUtils.splitInLines((String)code);
        for (String line : splitted) {
            if (!indentCommentLinesAt0Pos && line.startsWith("#") || line.trim().length() <= 0) continue;
            int found = PySelection.getFirstCharPosition((String)line);
            firstCharPosition = Math.min(found, firstCharPosition);
        }
        if (firstCharPosition != Integer.MAX_VALUE) {
            for (String line : splitted) {
                if (indentCommentLinesAt0Pos || !line.startsWith("#")) {
                    buf.append(indent);
                    if (line.length() > firstCharPosition) {
                        buf.append(line.substring(firstCharPosition));
                        continue;
                    }
                    buf.append(line);
                    continue;
                }
                buf.append(line);
            }
            return buf.toString();
        }
        return code;
    }

    public static String extractTextFromHTML(String html) {
        try {
            HTMLEditorKit kit = new HTMLEditorKit();
            Document doc = ((EditorKit)kit).createDefaultDocument();
            doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            StringReader rd = new StringReader(html);
            ((EditorKit)kit).read(rd, doc, 0);
            return doc.getText(0, doc.getLength());
        }
        catch (Exception exception) {
            return EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitWithIntern(String string, char toSplit, Collection<String> addTo) {
        Object object = ObjectsPool.lock;
        synchronized (object) {
            int len = string.length();
            int last = 0;
            char c = '\u0000';
            int i = 0;
            while (i < len) {
                c = string.charAt(i);
                if (c == toSplit) {
                    if (last != i) {
                        addTo.add(ObjectsPool.internUnsynched(string.substring(last, i)));
                    }
                    while (c == toSplit && i < len - 1) {
                        c = string.charAt(++i);
                    }
                    last = i;
                }
                ++i;
            }
            if (c != toSplit) {
                if (last == 0 && len > 0) {
                    addTo.add(ObjectsPool.internUnsynched(string));
                } else if (last < len) {
                    addTo.add(ObjectsPool.internUnsynched(string.substring(last, len)));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean split(String string, char toSplit, ICallbackOnSplit onSplit) {
        len = string.length();
        last = 0;
        c = '\u0000';
        i = 0;
        while (i < len) {
            block2: {
                c = string.charAt(i);
                if (c != toSplit) break block2;
                if (last == i || onSplit.call(string.substring(last, i))) ** GOTO lbl11
                return false;
lbl-1000:
                // 1 sources

                {
                    c = string.charAt(++i);
lbl11:
                    // 2 sources

                    ** while (c == toSplit && i < len - 1)
                }
lbl12:
                // 1 sources

                last = i;
            }
            ++i;
        }
        return c == toSplit || !(last == 0 && len > 0 ? onSplit.call(string) == false : last < len && onSplit.call(string.substring(last, len)) == false);
    }

    public static List<String> split(String string, char ... toSplit) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (StringUtils.contains(c, toSplit)) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                while (StringUtils.contains(c, toSplit) && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (!StringUtils.contains(c, toSplit)) {
            if (last == 0 && len > 0) {
                ret.add(string);
            } else if (last < len) {
                ret.add(string.substring(last, len));
            }
        }
        return ret;
    }

    public static List<String> splitAndRemoveEmptyNotTrimmed(String string, char c) {
        List split = StringUtils.split((String)string, (char)c);
        int i = split.size() - 1;
        while (i >= 0) {
            if (((String)split.get(i)).length() == 0) {
                split.remove(i);
            }
            --i;
        }
        return split;
    }

    public static List<String> splitAndRemoveEmptyTrimmed(String string, char c) {
        List split = StringUtils.split((String)string, (char)c);
        int i = split.size() - 1;
        while (i >= 0) {
            if (((String)split.get(i)).trim().length() == 0) {
                split.remove(i);
            }
            --i;
        }
        return split;
    }

    private static boolean contains(char c, char[] toSplit) {
        char[] cArray = toSplit;
        int n = toSplit.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (c == ch) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Tuple<String, String> splitOnFirst(String fullRep, char toSplit) {
        int i = fullRep.indexOf(toSplit);
        if (i != -1) {
            return new Tuple((Object)fullRep.substring(0, i), (Object)fullRep.substring(i + 1));
        }
        return new Tuple((Object)fullRep, (Object)EMPTY);
    }

    public static Tuple<String, String> splitOnFirst(String fullRep, String toSplit) {
        int i = fullRep.indexOf(toSplit);
        if (i != -1) {
            return new Tuple((Object)fullRep.substring(0, i), (Object)fullRep.substring(i + toSplit.length()));
        }
        return new Tuple((Object)fullRep, (Object)EMPTY);
    }

    public static List<String> dotSplit(String string) {
        return StringUtils.splitAndRemoveEmptyTrimmed(string, '.');
    }

    public static char[] addChar(char[] c, char toAdd) {
        char[] c1 = new char[c.length + 1];
        System.arraycopy(c, 0, c1, 0, c.length);
        c1[c.length] = toAdd;
        return c1;
    }

    public static String[] addString(String[] c, String toAdd) {
        String[] c1 = new String[c.length + 1];
        System.arraycopy(c, 0, c1, 0, c.length);
        c1[c.length] = toAdd;
        return c1;
    }

    public static String removeNewLineChars(String message) {
        return message.replaceAll("\r", EMPTY).replaceAll("\n", EMPTY);
    }

    public static String asStyleLowercaseUnderscores(String string) {
        int len = string.length();
        FastStringBuffer buf = new FastStringBuffer(len * 2);
        int lastState = 0;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                if (lastState != 1 && buf.length() > 0 && buf.lastChar() != '_') {
                    buf.append('_');
                }
                buf.append(Character.toLowerCase(c));
                lastState = 1;
            } else if (Character.isDigit(c)) {
                if (lastState != 2 && buf.length() > 0 && buf.lastChar() != '_') {
                    buf.append('_');
                }
                buf.append(c);
                lastState = 2;
            } else {
                buf.append(c);
                lastState = 0;
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean isAllUpper(String string) {
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String asStyleCamelCaseFirstLower(String string) {
        if (StringUtils.isAllUpper(string)) {
            string = string.toLowerCase();
        }
        int len = string.length();
        FastStringBuffer buf = new FastStringBuffer(len);
        boolean first = true;
        int nextUpper = 0;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (first) {
                if (c == '_') {
                    buf.append(c);
                } else {
                    buf.append(Character.toLowerCase(c));
                    first = false;
                }
            } else if (c == '_') {
                ++nextUpper;
            } else {
                if (nextUpper > 0) {
                    c = Character.toUpperCase(c);
                    nextUpper = 0;
                }
                buf.append(c);
            }
            ++i;
        }
        if (nextUpper > 0) {
            buf.appendN('_', nextUpper);
        }
        return buf.toString();
    }

    public static String asStyleCamelCaseFirstUpper(String string) {
        if ((string = StringUtils.asStyleCamelCaseFirstLower(string)).length() > 0) {
            return String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1);
        }
        return string;
    }

    public static boolean endsWith(FastStringBuffer str, char c) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(str.length() - 1) == c;
    }

    public static boolean endsWith(String str, char c) {
        int len = str.length();
        if (len == 0) {
            return false;
        }
        return str.charAt(len - 1) == c;
    }

    public static boolean endsWith(StringBuffer str, char c) {
        int len = str.length();
        if (len == 0) {
            return false;
        }
        return str.charAt(len - 1) == c;
    }

    public static boolean isWord(String str) {
        int len = str.length();
        if (str == null || len == 0) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOpeningPeer(char lastChar) {
        return lastChar == '(' || lastChar == '[' || lastChar == '{';
    }

    public static boolean hasOpeningBracket(String trimmedLine) {
        return trimmedLine.indexOf(123) != -1 || trimmedLine.indexOf(40) != -1 || trimmedLine.indexOf(91) != -1;
    }

    public static boolean hasClosingBracket(String trimmedLine) {
        return trimmedLine.indexOf(125) != -1 || trimmedLine.indexOf(41) != -1 || trimmedLine.indexOf(93) != -1;
    }

    public static boolean hasUnbalancedClosingPeers(String line) {
        HashMap<Character, Integer> stack = new HashMap<Character, Integer>();
        int len = line.length();
        int i = 0;
        while (i < len) {
            char c = line.charAt(i);
            switch (c) {
                case '(': 
                case '[': 
                case '{': {
                    Integer iStack = (Integer)stack.get(Character.valueOf(c));
                    if (iStack == null) {
                        iStack = 0;
                    }
                    iStack = iStack + 1;
                    stack.put(Character.valueOf(c), iStack);
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    char peer = org.python.pydev.shared_core.string.StringUtils.getPeer((char)c);
                    Integer iStack = (Integer)stack.get(Character.valueOf(peer));
                    if (iStack == null) {
                        iStack = 0;
                    }
                    iStack = iStack - 1;
                    stack.put(Character.valueOf(peer), iStack);
                }
            }
            ++i;
        }
        Iterator iterator = stack.values().iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i >= 0) continue;
            return true;
        }
        return false;
    }

    public static int count(String name, char c) {
        int count = 0;
        int len = name.length();
        int i = 0;
        while (i < len) {
            if (name.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String urlEncodeKeyValuePair(String key, String value) {
        String result = null;
        try {
            result = String.valueOf(URLEncoder.encode(key, "UTF-8")) + "=" + URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.log(e);
        }
        return result;
    }

    public static boolean containsWhitespace(String name) {
        int len = name.length();
        int i = 0;
        while (i < len) {
            if (Character.isWhitespace(name.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPythonIdentifier(String param) {
        int len = param.length();
        if (len == 0) {
            return false;
        }
        char c = param.charAt(0);
        if (!Character.isLetter(c) && c != '_' && c <= '\u0080') {
            return false;
        }
        int i = 1;
        while (i < len) {
            c = param.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_' && c <= '\u0080') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getWithFirstUpper(String creationStr) {
        int len = creationStr.length();
        if (len == 0) {
            return creationStr;
        }
        char upperCase = Character.toUpperCase(creationStr.charAt(0));
        return String.valueOf(upperCase) + creationStr.substring(1);
    }

    public static String indentTo(String source, String indent) {
        return StringUtils.indentTo(source, indent, true);
    }

    public static String indentTo(String source, String indent, boolean indentFirstLine) {
        int indentLen = indent.length();
        if (indent == null || indentLen == 0) {
            return source;
        }
        List splitInLines = StringUtils.splitInLines((String)source);
        int sourceLen = source.length();
        FastStringBuffer buf = new FastStringBuffer(sourceLen + splitInLines.size() * indentLen + 2);
        int i = 0;
        while (i < splitInLines.size()) {
            String line = (String)splitInLines.get(i);
            if (indentFirstLine || i > 0) {
                buf.append(indent);
            }
            buf.append(line);
            ++i;
        }
        return buf.toString();
    }

    public static String getExeAsFileSystemValidPath(String executableOrJar) {
        return "v1_" + org.python.pydev.shared_core.string.StringUtils.md5((String)executableOrJar);
    }

    public static byte[] decodeBase64(String persisted) {
        return Base64Coder.decode((char[])persisted.toCharArray());
    }

    public static String getObjAsStr(Object o) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream stream = new ObjectOutputStream(out);
            stream.writeObject(o);
            stream.close();
        }
        catch (Exception e) {
            Log.log(e);
            throw new RuntimeException(e);
        }
        return new String(StringUtils.encodeBase64(out));
    }

    public static char[] encodeBase64(ByteArrayOutputStream out) {
        byte[] byteArray = out.toByteArray();
        return StringUtils.encodeBase64(byteArray);
    }

    public static char[] encodeBase64(byte[] byteArray) {
        return Base64Coder.encode((byte[])byteArray);
    }

    public static interface ICallbackOnSplit {
        public boolean call(String var1);
    }
}

