/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.cache;

import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PyPreferencesCache
implements IPropertyChangeListener {
    private IPreferenceStore preferenceStore;
    private HashMap<String, Object> cache = new HashMap();

    public PyPreferencesCache(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public boolean getBoolean(String key) {
        Boolean b = (Boolean)this.cache.get(key);
        if (b == null) {
            b = this.preferenceStore.getBoolean(key);
            this.cache.put(key, b);
        }
        return b;
    }

    public int getInt(String key, int defaultIfZeroOrLess) {
        Integer b = (Integer)this.cache.get(key);
        if (b == null || b <= 0) {
            b = this.preferenceStore.getInt(key);
            if (b <= 0) {
                b = defaultIfZeroOrLess;
            }
            this.cache.put(key, b);
        }
        return b;
    }

    public int getInt(String key) {
        Integer b = (Integer)this.cache.get(key);
        if (b == null) {
            b = this.preferenceStore.getInt(key);
            this.cache.put(key, b);
        }
        return b;
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object newValue = event.getNewValue();
        this.cache.put(event.getProperty(), newValue);
    }

    public void clear(String key) {
        this.cache.put(key, null);
    }
}

