/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.utility.iterator;

import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleElementListIterator<E>
implements ListIterator<E> {
    private E element;
    private E next;
    private static final Object END = new Object();

    public SingleElementListIterator(E element) {
        this.next = element;
        this.element = element;
    }

    @Override
    public void add(E item) {
        throw new UnsupportedOperationException("This SingleElementListIterator is read-only.");
    }

    @Override
    public boolean hasNext() {
        return this.next == this.element;
    }

    @Override
    public boolean hasPrevious() {
        return this.next == END;
    }

    public ListIterator<E> iterator() {
        return this;
    }

    @Override
    public E next() {
        if (this.next == END) {
            throw new NoSuchElementException("No more elements can be retrieved.");
        }
        this.next = END;
        return this.element;
    }

    @Override
    public int nextIndex() {
        return this.next == this.element ? 0 : 1;
    }

    @Override
    public E previous() {
        if (this.next == this.element) {
            throw new NoSuchElementException("No more elements can be retrieved.");
        }
        this.next = this.element;
        return this.element;
    }

    @Override
    public int previousIndex() {
        return this.next == END ? 0 : -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This SingleElementListIterator is read-only.");
    }

    @Override
    public void set(E item) {
        throw new UnsupportedOperationException("This SingleElementListIterator is read-only.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append(this.element);
        sb.append(")");
        return sb.toString();
    }
}

