/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.struts.ui.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.struts.ui.util.WebAppCopier;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.osgi.framework.Bundle;

public class FacetUtil {
    public static void refreshProject(IProject project) {
        IPath projectLocation = project.getLocation();
        IContainer projectResource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(projectLocation);
        try {
            projectResource.refreshLocal(2, null);
        }
        catch (CoreException e) {
            LoggingService.logError((String)"oracle.eclipse.tools.webtier.struts.ui", (String)e.getLocalizedMessage());
        }
    }

    public static IPath getWebContentPath(IProject project) throws CoreException {
        return FacetUtil.resolveConfigPath(project, "");
    }

    public static IPath getWebInfPath(IProject project) throws CoreException {
        return FacetUtil.resolveConfigPath(project, "WEB-INF");
    }

    public static File getWebContentFolder(IProject project) throws CoreException {
        return FacetUtil.getWebContentPath(project).toFile();
    }

    public static File getWebInfFolder(IProject project) throws CoreException {
        return FacetUtil.getWebInfPath(project).toFile();
    }

    public static File getWebProjectFolder(IProject project) {
        return new File(project.getLocationURI());
    }

    public static File getWebProjectSrcFolder(IProject project) {
        return project.getLocation().append("src").toFile();
    }

    public static File getBundleFolder(Plugin plugin, String folder) throws IOException, URISyntaxException {
        Bundle bundle = plugin.getBundle();
        URL bundleUrl = bundle.getEntry(folder);
        URL fileUrl = FileLocator.toFileURL((URL)bundleUrl);
        File folderDirectory = new File(fileUrl.toURI());
        return folderDirectory;
    }

    public static IPath resolveConfigPath(IProject project, String configPath) throws CoreException {
        IContainer underlyingFolder = FacetUtil.getWebContentFolderIResource(project);
        IPath rawLocation = underlyingFolder.getRawLocation();
        if (rawLocation == null) {
            throw FacetUtil.cannotResolveProjectPathException();
        }
        Path path = new Path(configPath);
        if (configPath == null) {
            throw FacetUtil.cannotResolveProjectPathException();
        }
        return rawLocation.append((IPath)path);
    }

    public static String getWebContentFolderName(IProject project) throws CoreException {
        return FacetUtil.getWebContentFolderIResource(project).getName();
    }

    public static IContainer getWebContentFolderIResource(IProject project) throws CoreException {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            throw FacetUtil.cannotResolveProjectPathException();
        }
        IVirtualFolder rootFolder = component.getRootFolder();
        if (rootFolder == null) {
            throw FacetUtil.cannotResolveProjectPathException();
        }
        IContainer underlyingFolder = rootFolder.getUnderlyingFolder();
        if (underlyingFolder == null) {
            throw FacetUtil.cannotResolveProjectPathException();
        }
        return underlyingFolder;
    }

    private static CoreException cannotResolveProjectPathException() {
        return new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.webtier.struts.ui", "Cannot resolve project config path"));
    }

    public static final Map<File, File> copyFiles(File srcFolder, File targetFolder) throws IOException {
        return FacetUtil.copyFiles(srcFolder, targetFolder, null, true, null);
    }

    public static final Map<File, File> copyFiles(File srcFolder, File targetFolder, Map<File, File> map, boolean overwrite, Pattern[] excludePatterns) throws IOException {
        WebAppCopier copier = new WebAppCopier(srcFolder, targetFolder, overwrite, excludePatterns);
        copier.copy();
        Map<File, File> existingFiles = copier.getExistingFiles();
        if (existingFiles != null && existingFiles.size() > 0) {
            if (map == null) {
                return existingFiles;
            }
            map.putAll(existingFiles);
            return map;
        }
        return map;
    }
}

