/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.struts.ui.internal;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.struts.ui.internal.StrutsUiPlugin;
import oracle.eclipse.tools.webtier.struts.ui.util.FacetUtil;
import oracle.eclipse.tools.webtier.struts.ui.util.StrutsUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetInstallConfig;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class StrutsFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)2);
        try {
            try {
                this.setupLibraries(project, config, monitor);
                this.copyJspTemplates(project, fv, monitor);
                this.updateWebXml(project);
            }
            catch (IOException e) {
                LoggingService.logError((String)"oracle.eclipse.tools.webtier.struts.ui", (String)e.getLocalizedMessage());
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
            }
            catch (URISyntaxException e) {
                LoggingService.logError((String)"oracle.eclipse.tools.webtier.struts.ui", (String)e.getLocalizedMessage());
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private void setupLibraries(IProject project, Object config, IProgressMonitor monitor) throws CoreException {
        LibraryFacetInstallConfig cfg = (LibraryFacetInstallConfig)config;
        if (cfg.getFacetedProjectWorkingCopy().getProject() == null) {
            cfg.getFacetedProjectWorkingCopy().setProjectName(project.getName());
        }
        cfg.getLibraryInstallDelegate().execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
    }

    private void copyJspTemplates(IProject project, IProjectFacetVersion fv, IProgressMonitor monitor) throws IOException, URISyntaxException, CoreException {
        String newWebAppfolderName = StrutsUtil.getTemplatesFolderName(fv);
        File templatesWebContentFolder = FacetUtil.getBundleFolder(StrutsUiPlugin.getDefault(), "templates/new-app/" + newWebAppfolderName + "/web");
        File projectWebContentFolder = FacetUtil.getWebContentFolder(project);
        FacetUtil.copyFiles(templatesWebContentFolder, projectWebContentFolder, null, false, null);
        File templatesSrcFolder = FacetUtil.getBundleFolder(StrutsUiPlugin.getDefault(), "templates/new-app/" + newWebAppfolderName + "/src");
        File webProjectSrcFolder = FacetUtil.getWebProjectSrcFolder(project);
        FacetUtil.copyFiles(templatesSrcFolder, webProjectSrcFolder, null, false, null);
        FacetUtil.refreshProject(project);
    }

    private void updateWebXml(IProject project) {
        IModelProvider provider;
        Shell shell = null;
        Display display = Display.getCurrent();
        if (display != null) {
            shell = display.getActiveShell();
        }
        if ((provider = ModelProviderManager.getModelProvider((IProject)project)).validateEdit(null, (Object)shell).isOK()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    StrutsFacetInstallDelegate.this.editWebXml(provider);
                }
            };
            provider.modify(runnable, IModelProvider.FORCESAVE);
        }
    }

    private void editWebXml(IModelProvider provider) {
        try {
            Object modelObject = provider.getModelObject();
            if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
                Servlet servlet = WebapplicationFactory.eINSTANCE.createServlet();
                servlet.setServletName("action");
                ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
                servletType.setClassName("org.apache.struts.action.ActionServlet");
                servlet.setWebType((WebType)servletType);
                servlet.setLoadOnStartup(Integer.valueOf(2));
                if (webApp.getJ2EEVersionID() >= 14) {
                    ParamValue param1 = CommonFactory.eINSTANCE.createParamValue();
                    param1.setName("config");
                    param1.setValue("/WEB-INF/config/struts-config.xml");
                    servlet.getInitParams().add((Object)param1);
                    ParamValue param2 = CommonFactory.eINSTANCE.createParamValue();
                    param2.setName("debug");
                    param2.setValue("2");
                    servlet.getInitParams().add((Object)param2);
                    ParamValue param3 = CommonFactory.eINSTANCE.createParamValue();
                    param3.setName("detail");
                    param3.setValue("2");
                    servlet.getInitParams().add((Object)param3);
                } else {
                    InitParam ip1 = WebapplicationFactory.eINSTANCE.createInitParam();
                    ip1.setParamName("config");
                    ip1.setParamValue("/WEB-INF/config/struts-config.xml");
                    servlet.getParams().add((Object)ip1);
                    InitParam ip2 = WebapplicationFactory.eINSTANCE.createInitParam();
                    ip2.setParamName("debug");
                    ip2.setParamValue("2");
                    servlet.getParams().add((Object)ip2);
                    InitParam ip3 = WebapplicationFactory.eINSTANCE.createInitParam();
                    ip3.setParamName("detail");
                    ip3.setParamValue("2");
                    servlet.getParams().add((Object)ip3);
                }
                webApp.getServlets().add((Object)servlet);
                org.eclipse.jst.j2ee.webapplication.ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
                mapping.setServlet(servlet);
                mapping.setName(servlet.getServletName());
                mapping.setUrlPattern("*.do");
                webApp.getServletMappings().add((Object)mapping);
            } else if (modelObject instanceof WebApp) {
                WebApp webApp = (WebApp)modelObject;
                org.eclipse.jst.javaee.web.Servlet servlet = WebFactory.eINSTANCE.createServlet();
                servlet.setServletName("action");
                servlet.setServletClass("org.apache.struts.action.ActionServlet");
                servlet.setLoadOnStartup((Object)2);
                org.eclipse.jst.javaee.core.ParamValue param1 = JavaeeFactory.eINSTANCE.createParamValue();
                param1.setParamName("config");
                param1.setParamValue("/WEB-INF/config/struts-config.xml");
                servlet.getInitParams().add(param1);
                org.eclipse.jst.javaee.core.ParamValue param2 = JavaeeFactory.eINSTANCE.createParamValue();
                param2.setParamName("debug");
                param2.setParamValue("2");
                servlet.getInitParams().add(param2);
                org.eclipse.jst.javaee.core.ParamValue param3 = JavaeeFactory.eINSTANCE.createParamValue();
                param3.setParamName("detail");
                param3.setParamValue("2");
                servlet.getInitParams().add(param3);
                webApp.getServlets().add(servlet);
                ServletMapping mapping = WebFactory.eINSTANCE.createServletMapping();
                mapping.setServletName(servlet.getServletName());
                UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                urlPattern.setValue("*.do");
                mapping.getUrlPatterns().add(urlPattern);
                webApp.getServletMappings().add(mapping);
            }
        }
        catch (Exception ex) {
            LoggingService.logError((String)"oracle.eclipse.tools.webtier.struts.ui", (String)("Could not write web.xml" + ex));
        }
    }
}

