/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.SourceFirstPackageSelectionDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabelProvider;

class PackageSelectionStringButtonAdapter
implements IStringButtonAdapter {
    private final SourceFirstPackageSelectionDialogField fPackageSelectionField;
    private String fEmtpyListMessage;
    private String fMessage;
    private String fTitle;

    PackageSelectionStringButtonAdapter(SourceFirstPackageSelectionDialogField field, String title, String message, String emtpyListMessage) {
        this.fPackageSelectionField = field;
        this.fTitle = title;
        this.fMessage = message;
        this.fEmtpyListMessage = emtpyListMessage;
    }

    @Override
    public void changeControlPressed(DialogField field) {
        IPackageFragmentRoot root = this.fPackageSelectionField.getSelectedFragmentRoot();
        Object[] packages = null;
        try {
            if (root != null && root.exists()) {
                packages = root.getChildren();
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        if (packages == null) {
            packages = new IJavaScriptElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(field.getLabelControl(null).getShell(), (ILabelProvider)new JavaScriptElementLabelProvider(JavaScriptElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(true);
        dialog.setTitle(this.fTitle);
        dialog.setMessage(this.fMessage);
        dialog.setEmptyListMessage(this.fEmtpyListMessage);
        dialog.setElements(packages);
        if (dialog.open() == 0) {
            IPackageFragment fragment = (IPackageFragment)dialog.getFirstResult();
            this.fPackageSelectionField.setSelected(fragment);
        }
    }
}

