/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.antbase;

import java.io.Console;
import java.util.Arrays;
import oracle.cloudlogic.javaservice.common.antbase.AntBaseTask;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import org.apache.tools.ant.BuildException;

public class PasswordReader
extends AntBaseTask {
    private String prompt;
    private String propertytoset;
    private boolean echo = false;

    private void setAntProperty(String name, String val) {
        if (name != null) {
            name = name.trim();
            if (this.getProject().getProperty(name) != null) {
                this.getProject().setProperty(name, val);
            } else if (val != null) {
                this.getProject().setNewProperty(name, val);
            }
        }
    }

    public CommandLine getCommandLine() {
        return new CommandLine();
    }

    public void execute() throws BuildException {
        try {
            if (this.prompt == null) {
                this.prompt = "Enter";
            }
            if (this.propertytoset == null || this.getPropertytoset().trim().equals("")) {
                throw new Exception("Attribute propertytoset is required");
            }
            String pwd = this.getProject().getProperty(this.propertytoset);
            if (pwd != null && pwd.startsWith("${") && pwd.endsWith("}")) {
                pwd = null;
            }
            if (pwd == null) {
                char[] data = null;
                if (this.echo) {
                    System.out.println("********  Please Enter  *********");
                    data = PasswordReader.readPassword(this.prompt);
                } else {
                    System.out.println("******** Please Enter. The value will not be echoed  *********");
                    Console cons = null;
                    cons = System.console();
                    if (cons == null || (data = cons.readPassword("[%s]", this.prompt)) != null) {
                        // empty if block
                    }
                }
                if (data == null) {
                    throw new Exception("No value was entered.");
                }
                this.setAntProperty(this.propertytoset, new String(data));
                Arrays.fill(data, ' ');
                Object var2_3 = null;
            } else {
                System.out.println(this.prompt + " already exists.");
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPropertytoset(String passwordproperty) {
        this.propertytoset = passwordproperty;
    }

    public String getPropertytoset() {
        return this.propertytoset;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public static char[] readPassword(String prompt) {
        Console cons = null;
        char[] passwd = null;
        cons = System.console();
        if (cons != null && (passwd = cons.readPassword("[%s]", prompt)) != null && passwd.length == 0) {
            passwd = null;
        }
        return passwd;
    }
}

