/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.antbase;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.Path;

public abstract class AntBaseTask
extends Task {
    protected boolean failonerror = false;
    protected boolean bg = false;
    protected CommandLine cmd = null;
    protected FileList fileList = null;
    protected CommandlineJava cmdJava = new CommandlineJava();
    protected AntClassLoader classLoader;

    public FileList createFileList() {
        if (!this.supportsNestedFileList()) {
            throw new BuildException("filelist is not supported.");
        }
        this.fileList = new FileList();
        return this.fileList;
    }

    public Path createClasspath() {
        if (!this.supportsNestedClassPath()) {
            throw new BuildException("classpath is not supported.");
        }
        return this.cmdJava.createClasspath(this.getProject()).createPath();
    }

    protected boolean supportsNestedClassPath() {
        return false;
    }

    protected boolean supportsNestedFileList() {
        return false;
    }

    protected void createAndSetClassLoader() {
        Path userClasspath = this.cmdJava.getClasspath();
        if (userClasspath != null && this.classLoader == null) {
            Path classpath = (Path)userClasspath.clone();
            this.classLoader = this.getProject().createClassLoader(((Object)((Object)this)).getClass().getClassLoader(), classpath);
            this.classLoader.setThreadContextLoader();
        } else {
            this.classLoader = this.getProject().createClassLoader(((Object)((Object)this)).getClass().getClassLoader(), null);
            this.classLoader.setThreadContextLoader();
        }
    }

    public void createAndSetFileList() throws IOException {
        if (this.fileList == null) {
            return;
        }
        File dir = this.fileList.getDir(this.getProject());
        ArrayList<String> extraArgs = new ArrayList<String>();
        String[] files = this.fileList.getFiles(this.getProject());
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            extraArgs.add(file.getCanonicalPath());
        }
        this.cmd.setExtraArgs(extraArgs);
    }

    public void setFailonerror(boolean failOnError) {
        this.failonerror = failOnError;
    }

    public boolean isFailonerror() {
        return this.failonerror;
    }

    public abstract CommandLine getCommandLine();

    public void performCli() throws Exception {
        this.cmd.perform();
    }

    public void init() throws BuildException {
        try {
            this.cmd = (CommandLine)this.getCommandLine().simpleClone();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.createAndSetClassLoader();
        if (this.bg && this.failonerror) {
            throw new BuildException("Both bg and failonerror cant be true");
        }
        try {
            this.createAndSetFileList();
        }
        catch (Exception ce) {
            throw new BuildException(ce.getMessage(), (Throwable)ce);
        }
        try {
            if (this.bg) {
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            AntBaseTask.this.performCli();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                t.start();
            } else {
                this.performCli();
            }
        }
        catch (Exception e) {
            if (this.cmd.toEnableDebug()) {
                Logger.getDEFAULT().addAllowed(Logger.LOG_MESSAGE_TYPES.TRACE);
            }
            Logger.getDEFAULT().println();
            CloudUtil.handleFinalException((Throwable)e, (boolean)true);
            Logger.getDEFAULT().println();
            if (this.failonerror) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (this.classLoader != null) {
                this.classLoader.resetThreadContextLoader();
            }
        }
    }

    protected void checkAndPutvalue(String val) throws BuildException {
        try {
            throw new Exception("Dummy");
        }
        catch (Exception e) {
            StackTraceElement[] stack = e.getStackTrace();
            String methodName = stack[1].getMethodName();
            if (!methodName.startsWith("set")) {
                throw new BuildException("This method should be called from a setter: Called method name is " + methodName);
            }
            String attrib = methodName.substring(3, methodName.length());
            if (attrib.length() == 0) {
                throw new BuildException("Invalid attrib Name");
            }
            attrib = attrib.substring(0, 1).toLowerCase() + attrib.substring(1, attrib.length());
            CommandLineArg arg = (CommandLineArg)this.cmd.getArgs().get((Object)attrib);
            if (arg == null) {
                throw new BuildException("Un-supported Attrib:" + attrib);
            }
            arg.setOptionValue(val);
            return;
        }
    }

    public void setAdminUrl(String value) {
        this.checkAndPutvalue(value);
    }
}

