/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class EclipsePreferencesHelper {
    public static final String PROPS_OVERRIDDEN_BY_CSS_PROP = "overriddenByCSS";
    public static final String SEPARATOR = ",";
    private static final String MULTI_VALUE_FORMATTER = "%s%s,";

    public static void appendOverriddenPropertyName(IEclipsePreferences preferences, String name) {
        String value = preferences.get(PROPS_OVERRIDDEN_BY_CSS_PROP, SEPARATOR);
        if (!value.contains(SEPARATOR + name + SEPARATOR)) {
            preferences.put(PROPS_OVERRIDDEN_BY_CSS_PROP, String.format(MULTI_VALUE_FORMATTER, value, name));
        }
    }

    public static List<String> getOverriddenPropertyNames(IEclipsePreferences preferences) {
        String value = preferences.get(PROPS_OVERRIDDEN_BY_CSS_PROP, null);
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = value.split(SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name != null && !name.isEmpty()) {
                result.add(name);
            }
            ++n2;
        }
        return result;
    }

    public static void removeOverriddenPropertyNames(IEclipsePreferences preferences) {
        preferences.remove(PROPS_OVERRIDDEN_BY_CSS_PROP);
    }
}

