/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import oracle.eclipse.tools.adf.dtrt.internal.DTRTBundle;
import oracle.eclipse.tools.adf.dtrt.jdt.JDTUtil;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescribable;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DescribableResource;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;

public final class StructureSourceFactory {
    private StructureSourceFactory() {
    }

    public static IStructure.ITypeSource createTypeSource(IType type) {
        return type != null ? new TypeSource(type) : null;
    }

    public static IStructure.ITypeSource createTypeSource(ITypeRoot typeRoot) {
        return typeRoot != null ? StructureSourceFactory.createTypeSource(typeRoot.findPrimaryType()) : null;
    }

    public static IStructure.ITypeSource createTypeSource(IFile file) {
        if (file != null) {
            try {
                ICompilationUnit compilationUnit = JDTUtil.getNoCachingTypeHelper().getCompilationUnit(file, false);
                if (compilationUnit != null) {
                    IType[] iTypeArray = compilationUnit.getTypes();
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType type = iTypeArray[n2];
                        if (Flags.isPublic((int)type.getFlags())) {
                            return StructureSourceFactory.createTypeSource(type);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                DTRTBundle.log(e);
            }
        }
        return null;
    }

    public static IStructure.IStructureSource createFileSource(IFile file) {
        return file != null ? new FileSource(file) : null;
    }

    private static final class FileSource
    extends DescribableResource
    implements IStructure.IStructureSource {
        public FileSource(IFile file) {
            super((IResource)file);
        }

        @Override
        public IResource getResource() {
            return (IResource)this.getDecoratedObject();
        }

        public Object getAdapter(Class adapter) {
            return adapter == ImageManager.IImageData.class ? this.getImageData() : (adapter == IResource.class ? this.getResource() : (adapter == IFile.class ? this.getResource() : null));
        }
    }

    private static final class TypeSource
    extends BaseDescribable
    implements IStructure.ITypeSource {
        private final IType type;
        private IResource resource;

        private TypeSource(IType type) {
            assert (type != null);
            assert (type.getJavaProject() != null);
            this.type = type;
        }

        @Override
        public void dispose() {
            this.resource = null;
            super.dispose();
        }

        @Override
        public IType getType() {
            return this.type;
        }

        @Override
        public IResource getResource() {
            return this.resource == null ? (this.resource = this.type.getResource()) : this.resource;
        }

        @Override
        protected BaseDescriptor createDescriptor() {
            return new BaseDescriptor(){

                @Override
                public String getLabel() {
                    return TypeSource.this.getType().getFullyQualifiedName();
                }

                @Override
                public String getToolTipText() {
                    IResource resource = TypeSource.this.getResource();
                    return resource != null ? resource.getFullPath().toString() : null;
                }

                @Override
                public ImageManager.IImageData getImageData() {
                    return ImageManager.getInstance().getWorkbenchImageData(TypeSource.this.getType());
                }
            };
        }

        @Override
        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TypeSource other = (TypeSource)obj;
            return JDTUtil.equals(this.type, other.type);
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IResource.class || adapter == IFile.class) {
                IResource resource = this.getResource();
                return adapter == IResource.class || resource instanceof IFile ? resource : null;
            }
            return adapter == ImageManager.IImageData.class ? this.getDescriptor().getImageData() : null;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TypeSource [type=");
            builder.append(this.type.getFullyQualifiedName());
            builder.append("]");
            return builder.toString();
        }
    }
}

