/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public final class SSEUtil {
    private SSEUtil() {
    }

    public static IFile getAccessibleFile(IDOMNode node) {
        return node != null ? SSEUtil.getAccessibleFile((IStructuredModel)node.getModel()) : null;
    }

    public static IFile getAccessibleFile(IStructuredModel model) {
        String id;
        String path;
        if (model != null && !DTRTUtil.isEmpty(path = model.getBaseLocation()) && (id = model.getId()) != null) {
            path = id.toString();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = root.findMember(path);
            if (resource instanceof IFile) {
                return (IFile)resource;
            }
        }
        return null;
    }

    private static int getLineOfOffset(IDOMNode node, int offset) {
        IStructuredDocument structuredDocument;
        if (node != null && offset >= 0 && (structuredDocument = node.getStructuredDocument()) != null) {
            try {
                return structuredDocument.getLineOfOffset(offset) + 1;
            }
            catch (Exception exception) {}
        }
        return -1;
    }

    public static int[] computeLineNumbers(IDOMNode node) {
        int endLine;
        int startLine;
        int end;
        int start;
        if (node != null && (start = node.getStartOffset()) >= 0 && (end = node.getEndOffset()) > start && (startLine = SSEUtil.getLineOfOffset(node, start)) >= 0 && (endLine = SSEUtil.getLineOfOffset(node, end)) >= startLine) {
            return new int[]{startLine, endLine};
        }
        return null;
    }

    public static int[] computeRegion(IDOMNode node) {
        int endOffset;
        int startOffset;
        if (node != null && (startOffset = node.getStartOffset()) >= 0 && (endOffset = node.getEndOffset()) > startOffset) {
            return new int[]{startOffset, endOffset - startOffset};
        }
        return null;
    }
}

