/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.internal.DTRTBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class SSEMonitor {
    private static final ISSEListener[] EMPTY_ARRAY = new ISSEListener[0];
    private final NodeAdapter nodeAdapter = new NodeAdapter();
    private IDOMDocument monitoredDocument;
    private List<ISSEListener> listeners;

    public void dispose() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (this.monitoredDocument != null) {
            this.nodeAdapter.reset(this.monitoredDocument);
            this.monitoredDocument = null;
        }
    }

    public SSEMonitor addListener(ISSEListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ISSEListener>();
            }
            this.listeners.add(listener);
        }
        return this;
    }

    public SSEMonitor removeListener(ISSEListener listener) {
        if (listener != null && this.listeners != null && this.listeners.remove(listener) && this.listeners.isEmpty()) {
            this.listeners = null;
        }
        return this;
    }

    private ISSEListener[] getListenerArray() {
        return this.listeners != null ? this.listeners.toArray(new ISSEListener[this.listeners.size()]) : EMPTY_ARRAY;
    }

    public SSEMonitor stop() {
        this.nodeAdapter.reset(this.getMonitoredDocument());
        this.monitoredDocument = null;
        return this;
    }

    public SSEMonitor start(IDOMDocument document) throws IllegalStateException {
        return this.start(document, null);
    }

    public SSEMonitor start(IDOMDocument document, IFile file) throws IllegalStateException {
        if (document != null && this.getMonitoredDocument() != document) {
            this.checkMonitoring();
            this.monitoredDocument = document;
            this.nodeAdapter.monitor(document, null, file);
        }
        return this;
    }

    public SSEMonitor start(IStructuredModel model, IFile file) throws IllegalStateException {
        if (model != null && file != null) {
            this.checkMonitoring();
            this.nodeAdapter.monitor(null, model, file);
        }
        return this;
    }

    private void checkMonitoring() throws IllegalStateException {
        if (this.isMonitoring()) {
            throw new IllegalStateException("Already monitoring.");
        }
    }

    public boolean isMonitoring() {
        return this.getMonitoredDocument() != null || this.getMonitoredFile() != null;
    }

    public IDOMDocument getMonitoredDocument() {
        return this.monitoredDocument;
    }

    public IStructuredModel getMonitoredModel() {
        return this.nodeAdapter.getModel();
    }

    public IFile getMonitoredFile() {
        return this.nodeAdapter.getFile();
    }

    public static interface ISSEListener {
        public void handleChange(IDOMDocument var1);

        public void handleAdd(IDOMNode var1, IDOMElement var2);

        public void handleRemove(IDOMNode var1, IDOMElement var2);

        public void handleAttributeChange(IDOMElement var1, IDOMAttr var2, String var3, String var4);

        public void contentChanged(IDOMNode var1);

        public void modelReverted(IStructuredModel var1, IFile var2);

        public void modelSaved(IStructuredModel var1, IFile var2);
    }

    private class NodeAdapter
    implements INodeAdapter,
    IModelStateListener {
        private IStructuredModel model;
        private IFile file;
        private long modificationTimestamp;

        private NodeAdapter() {
        }

        public void reset(IDOMDocument document) {
            if (document != null) {
                document.getModel().removeModelStateListener((IModelStateListener)this);
                this.adapt((Node)document, false);
            }
            this.file = null;
            this.model = null;
            this.modificationTimestamp = -1L;
        }

        public final void monitor(IDOMDocument document, IStructuredModel model, IFile file) {
            if (document != null) {
                this.reset(document);
                this.adapt((Node)document, true);
                model = document.getModel();
            }
            if (model != null && file != null) {
                this.file = file;
                this.model = model;
                model.addModelStateListener((IModelStateListener)this);
                this.modificationTimestamp = file.getModificationStamp();
            } else {
                this.modificationTimestamp = -1L;
            }
        }

        public IFile getFile() {
            return this.file;
        }

        public IStructuredModel getModel() {
            return this.model;
        }

        public boolean isAdapterForType(Object type) {
            return type == this;
        }

        public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
            if (oldValue instanceof Text || newValue instanceof Text) {
                return;
            }
            if (notifier instanceof IDOMDocument || notifier instanceof IDOMElement) {
                IDOMNode domNotifier = (IDOMNode)notifier;
                switch (eventType) {
                    case 2: {
                        if (!(newValue instanceof IDOMElement)) break;
                        IDOMElement element = (IDOMElement)newValue;
                        this.adapt((Node)element, true);
                        this.notifyChange(domNotifier.getModel().getDocument());
                        this.notifyAdd(domNotifier, element);
                        break;
                    }
                    case 3: {
                        if (!(oldValue instanceof IDOMElement)) break;
                        IDOMElement element = (IDOMElement)oldValue;
                        this.adapt((Node)element, false);
                        this.notifyChange(domNotifier.getModel().getDocument());
                        this.notifyRemove(domNotifier, element);
                        break;
                    }
                    case 1: {
                        if (!(domNotifier instanceof IDOMElement) && !(changedFeature instanceof IDOMAttr)) break;
                        IDOMAttr attribute = (IDOMAttr)changedFeature;
                        this.notifyChange(domNotifier.getModel().getDocument());
                        this.notifyChange((IDOMElement)domNotifier, attribute, (String)oldValue, (String)newValue);
                        break;
                    }
                    case 5: {
                        this.notifyContentChanged(domNotifier);
                    }
                }
            }
        }

        private void adaptChildElements(Node parentNode, boolean adapt) {
            Node child = parentNode.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    this.adapt(child, adapt);
                }
                child = child.getNextSibling();
            }
        }

        private void adapt(Node node, boolean adapt) {
            assert (node instanceof Document || node instanceof Element) : "Must a document or element: " + node;
            INodeNotifier notifier = (INodeNotifier)node;
            if (notifier.getExistingAdapter((Object)this) == null) {
                if (adapt) {
                    notifier.addAdapter((INodeAdapter)this);
                }
            } else if (!adapt) {
                notifier.removeAdapter((INodeAdapter)this);
            }
            this.adaptChildElements(node, adapt);
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
        }

        public void modelChanged(IStructuredModel model) {
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
            if (this.getFile() != null && model == this.getModel()) {
                if (isDirty) {
                    this.modificationTimestamp = this.getFile().getModificationStamp();
                } else {
                    IDOMDocument document = ((IDOMModel)model).getDocument();
                    long timestamp = this.modificationTimestamp;
                    this.modificationTimestamp = -1L;
                    if (timestamp == this.getFile().getModificationStamp()) {
                        if (SSEMonitor.this.getMonitoredDocument() == document) {
                            this.adapt((Node)document, true);
                        }
                        this.notifyModelReverted(model, this.getFile());
                    } else {
                        this.notifyModelSaved(model, this.getFile());
                    }
                }
            }
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
        }

        private void notifyChange(IDOMDocument document) {
            ISSEListener[] iSSEListenerArray = SSEMonitor.this.getListenerArray();
            int n = iSSEListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISSEListener listener = iSSEListenerArray[n2];
                try {
                    listener.handleChange(document);
                }
                catch (Exception e) {
                    DTRTBundle.log(e);
                }
                ++n2;
            }
        }

        private void notifyAdd(IDOMNode parent, IDOMElement newElement) {
            ISSEListener[] iSSEListenerArray = SSEMonitor.this.getListenerArray();
            int n = iSSEListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISSEListener listener = iSSEListenerArray[n2];
                try {
                    listener.handleAdd(parent, newElement);
                }
                catch (Exception e) {
                    DTRTBundle.log(e);
                }
                ++n2;
            }
        }

        private void notifyRemove(IDOMNode parent, IDOMElement oldElement) {
            ISSEListener[] iSSEListenerArray = SSEMonitor.this.getListenerArray();
            int n = iSSEListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISSEListener listener = iSSEListenerArray[n2];
                try {
                    listener.handleRemove(parent, oldElement);
                }
                catch (Exception e) {
                    DTRTBundle.log(e);
                }
                ++n2;
            }
        }

        private void notifyChange(IDOMElement element, IDOMAttr attribute, String oldValue, String newValue) {
            ISSEListener[] iSSEListenerArray = SSEMonitor.this.getListenerArray();
            int n = iSSEListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISSEListener listener = iSSEListenerArray[n2];
                try {
                    listener.handleAttributeChange(element, attribute, oldValue, newValue);
                }
                catch (Exception e) {
                    DTRTBundle.log(e);
                }
                ++n2;
            }
        }

        private void notifyContentChanged(IDOMNode node) {
            ISSEListener[] iSSEListenerArray = SSEMonitor.this.getListenerArray();
            int n = iSSEListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISSEListener listener = iSSEListenerArray[n2];
                try {
                    listener.contentChanged(node);
                }
                catch (Exception e) {
                    DTRTBundle.log(e);
                }
                ++n2;
            }
        }

        private void notifyModelReverted(IStructuredModel model, IFile file) {
            ISSEListener[] iSSEListenerArray = SSEMonitor.this.getListenerArray();
            int n = iSSEListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISSEListener listener = iSSEListenerArray[n2];
                try {
                    listener.modelReverted(model, file);
                }
                catch (Exception e) {
                    DTRTBundle.log(e);
                }
                ++n2;
            }
        }

        private void notifyModelSaved(IStructuredModel model, IFile file) {
            ISSEListener[] iSSEListenerArray = SSEMonitor.this.getListenerArray();
            int n = iSSEListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISSEListener listener = iSSEListenerArray[n2];
                try {
                    listener.modelSaved(model, file);
                }
                catch (Exception e) {
                    DTRTBundle.log(e);
                }
                ++n2;
            }
        }
    }

    public static class SSEAdapter
    implements ISSEListener {
        @Override
        public void handleChange(IDOMDocument document) {
        }

        @Override
        public void handleAdd(IDOMNode parent, IDOMElement newElement) {
        }

        @Override
        public void handleRemove(IDOMNode parent, IDOMElement removedElement) {
        }

        @Override
        public void handleAttributeChange(IDOMElement element, IDOMAttr attribute, String oldValue, String newValue) {
        }

        @Override
        public void contentChanged(IDOMNode elementOrDocument) {
        }

        @Override
        public void modelReverted(IStructuredModel model, IFile file) {
        }

        @Override
        public void modelSaved(IStructuredModel model, IFile file) {
        }
    }
}

