/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescribable;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.ManagedBeanImpl;

public class ManagedBeanObjectImpl
extends BaseDescribable
implements IWebPageContext.IManagedBeanObject {
    private ManagedBeanObjectImpl parent;
    private List<IWebPageContext.IManagedBeanObject> children;
    private String el;
    private IComputeChildrenDelegator computeChildrenDelegator;
    private String label;
    private String toolTipText;
    private Object image;
    private Object decoratedObject;

    protected ManagedBeanObjectImpl(String label) {
        this.label = label;
        if (label == null) {
            throw new IllegalArgumentException("The label cannot be null");
        }
    }

    protected ManagedBeanObjectImpl(Object decoratedObject, String label) {
        this(label);
        this.decoratedObject = decoratedObject;
    }

    public ManagedBeanObjectImpl(ManagedBeanObjectImpl parent, Object decoratedObject, String label) {
        this(decoratedObject, label);
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        this.parent = parent;
    }

    public ManagedBeanObjectImpl getParent() {
        return this.parent;
    }

    @Override
    protected BaseDescriptor createDescriptor() {
        return new BaseDescriptor(){

            @Override
            public String getLabel() {
                return ManagedBeanObjectImpl.this.label;
            }

            @Override
            public String getToolTipText() {
                return ManagedBeanObjectImpl.this.toolTipText;
            }

            @Override
            public Object getImage() {
                return ManagedBeanObjectImpl.this.image;
            }
        };
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }

    public void setImage(Object image) {
        this.image = image;
    }

    public Object getDecoratedObject() {
        return this.decoratedObject;
    }

    public void setComputeChildrenDelegator(IComputeChildrenDelegator computeChildrenDelegator) {
        this.computeChildrenDelegator = computeChildrenDelegator;
    }

    public IComputeChildrenDelegator getComputeChildrenDelegator() {
        return this.computeChildrenDelegator;
    }

    @Override
    public List<? extends IWebPageContext.IManagedBeanObject> getChildren() {
        List<? extends IWebPageContext.IManagedBeanObject> list;
        if (this.getComputeChildrenDelegator() != null) {
            list = this.getComputeChildrenDelegator().getChildren(this);
        } else if (this.children == null) {
            this.children = new ArrayList<IWebPageContext.IManagedBeanObject>();
            list = this.children;
        } else {
            list = this.children;
        }
        return list;
    }

    protected String computeELExpression() {
        StringBuilder sb = new StringBuilder();
        return this.computeELExpression(sb) ? sb.toString() : null;
    }

    private boolean computeELExpression(StringBuilder sb) {
        if (this.getParent() == null) {
            assert (this instanceof ManagedBeanImpl);
            String el = this.computeELExpression();
            if (el != null) {
                sb.append(el);
                return true;
            }
            return false;
        }
        if (this.label != null && this.getParent().computeELExpression(sb)) {
            sb.append('.').append(this.label);
            return true;
        }
        return false;
    }

    @Override
    public final String getEL() {
        String expression;
        if (this.el == null && (expression = this.computeELExpression()) != null) {
            this.el = "${" + expression + '}';
        }
        return this.el;
    }

    @Override
    public int hashCode() {
        return this.baseHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.baseEquals(obj);
    }

    public static interface IComputeChildrenDelegator {
        public List<? extends IWebPageContext.IManagedBeanObject> getChildren(ManagedBeanObjectImpl var1);
    }
}

