/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ExecutableContextAdapter;
import oracle.eclipse.tools.adf.dtrt.util.ManagedBeanImpl;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.util.Pair;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ManagedBeanManagerImpl
implements IWebPageContext.IManagedBeanManager {
    private static final String RAW_BOUND_TO_TASK_FLOW = "rawBoundToTaskFlow";
    private IWebPageContext context;
    private ContextAdapter contextAdapter;
    private Map<ManagedBeanImpl, ManagedBeanState> stateMap = new HashMap<ManagedBeanImpl, ManagedBeanState>();

    protected void dispose() {
        if (this.context != null) {
            if (this.contextAdapter != null) {
                this.context.removeListener(this.contextAdapter);
                this.contextAdapter = null;
            }
            this.context = null;
        }
        this.reset();
        this.stateMap = null;
    }

    @Override
    public void reset() {
        if (this.stateMap != null) {
            this.stateMap.clear();
        }
    }

    protected final void cleanAfterSave(Map<ManagedBeanImpl, ManagedBeanState> snapshot) {
        assert (snapshot != null);
        for (ManagedBeanState state : snapshot.values()) {
            assert (state.originalState != null);
            state.originalState.removed = false;
            state.originalState.removedTaskFlowBind = null;
            state.originalState.removedLinks = null;
            state.originalState = null;
        }
    }

    @Override
    public final void setContext(IWebPageContext context) {
        assert (this.context == null);
        this.context = context;
        this.contextAdapter = new ContextAdapter();
        context.addListener(this.contextAdapter);
    }

    public final IWebPageContext getContext() {
        return this.context;
    }

    public final Map<ManagedBeanImpl, ManagedBeanState> getSnapshot() {
        HashMap<ManagedBeanImpl, ManagedBeanState> clone = new HashMap<ManagedBeanImpl, ManagedBeanState>(this.stateMap);
        for (Map.Entry entry : clone.entrySet()) {
            entry.setValue(((ManagedBeanState)entry.getValue()).clone());
        }
        return Collections.unmodifiableMap(clone);
    }

    @Override
    public final boolean isBoundToTaskFlow(IWebPageContext.IManagedBean managedBean) {
        Boolean boundToTaskFlow;
        ManagedBeanState state = this.stateMap.get(managedBean);
        if (state != null && (boundToTaskFlow = state.getBoundToTaskFlow()) != null) {
            return boundToTaskFlow;
        }
        return this.isInitiallyBoundToTaskFlow(managedBean);
    }

    protected final boolean isInitiallyBoundToTaskFlow(IWebPageContext.IManagedBean managedBean) {
        return ((ManagedBeanImpl)managedBean).getData(RAW_BOUND_TO_TASK_FLOW) == Boolean.TRUE;
    }

    protected final void setInitiallyBoundToTaskFlow(IWebPageContext.IManagedBean managedBean, boolean bound) {
        ((ManagedBeanImpl)managedBean).setData(RAW_BOUND_TO_TASK_FLOW, bound);
    }

    @Override
    public List<? extends IWebPageContext.IManagedBean> collectManagedBeans(Map<String, String> taskFlowBindNameByManagedBeanName, IProgressMonitor monitor) throws Exception {
        HashSet<? extends ManagedBeanImpl> managedBeans = new HashSet<ManagedBeanImpl>(this.getInitialManagedBeans(taskFlowBindNameByManagedBeanName, monitor));
        for (Map.Entry<ManagedBeanImpl, ManagedBeanState> entry : this.stateMap.entrySet()) {
            ManagedBeanImpl managedBean = entry.getKey();
            ManagedBeanState state = entry.getValue();
            if (managedBeans.contains(managedBean)) {
                if (!state.isRemoved()) continue;
                managedBeans.remove(managedBean);
                continue;
            }
            if (!state.isAdded()) continue;
            managedBeans.add(managedBean);
        }
        if (!managedBeans.isEmpty()) {
            ArrayList<? extends ManagedBeanImpl> list = new ArrayList<ManagedBeanImpl>(managedBeans);
            Collections.sort(list, DTRTUtil.COMPARATOR);
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    protected abstract Collection<? extends ManagedBeanImpl> getInitialManagedBeans(Map<String, String> var1, IProgressMonitor var2) throws Exception;

    protected ManagedBeanImpl createManagedBean(String name) {
        return new ManagedBeanImpl(name);
    }

    @Override
    public ManagedBeanImpl addTaskFlowManagedBean(Variable.SCOPE scope, String name, String className, IPath javaFilePath, IProgressMonitor monitor) throws Exception {
        assert (scope != null);
        assert (name != null);
        assert (className != null);
        assert (javaFilePath != null);
        ManagedBeanImpl managedBean = this.createManagedBean(name);
        managedBean.setClassName(className);
        managedBean.setJavaFilePath(javaFilePath);
        managedBean.setScope(scope);
        ManagedBeanState state = this.stateMap.remove(managedBean);
        if (state != null && state.isAdded()) {
            throw new IllegalStateException("Managed bean already added");
        }
        state = new ManagedBeanState();
        this.stateMap.put(managedBean, state);
        state.add();
        return managedBean;
    }

    @Override
    public final void removeManagedBean(IWebPageContext.IManagedBean managedBean, IProgressMonitor monitor) throws Exception {
        assert (managedBean != null);
        ManagedBeanState state = this.stateMap.get(managedBean);
        if (state == null) {
            throw new IllegalStateException("Cannot remove a managed bean that was not added");
        }
        if (state.isRemoved()) {
            throw new IllegalStateException("Managed bean already removed");
        }
        state.remove();
    }

    @Override
    public void bindToTaskFlow(IWebPageContext.IManagedBean managedBean, String bindName, String taskFlowName, IProgressMonitor monitor) throws Exception {
        assert (managedBean != null);
        assert (bindName != null);
        assert (taskFlowName != null);
        if (this.isBoundToTaskFlow(managedBean)) {
            throw new IllegalStateException("Managed bean already bound to task flow");
        }
        ManagedBeanState state = this.stateMap.get(managedBean);
        if (state == null) {
            state = new ManagedBeanState();
            this.stateMap.put((ManagedBeanImpl)managedBean, state);
        } else if (state.isRemoved()) {
            throw new IllegalStateException("Managed bean has been removed");
        }
        state.setTaskFlowBind(bindName, taskFlowName);
    }

    @Override
    public Pair<String, String> unbindFromTaskFlow(IWebPageContext.IManagedBean managedBean, IProgressMonitor monitor) throws Exception {
        assert (managedBean != null);
        if (!this.isBoundToTaskFlow(managedBean)) {
            throw new IllegalStateException("Managed bean is not used");
        }
        ManagedBeanState state = this.stateMap.get(managedBean);
        if (state == null) {
            throw new IllegalStateException("Cannot unbind task flows unless they were bounded by this manager");
        }
        if (state.isRemoved()) {
            throw new IllegalStateException("Managed bean has been removed");
        }
        Pair<String, String> taskFlowBind = state.getTaskFlowBind();
        state.setTaskFlowBind(null, null);
        return taskFlowBind;
    }

    @Override
    public final void addLink(IWebPageContext.IManagedBean managedBean, String linkName, String taskFlowName) {
        assert (managedBean != null);
        assert (linkName != null);
        assert (taskFlowName != null);
        if (!this.isBoundToTaskFlow(managedBean)) {
            throw new IllegalStateException("Only managed beans binded to task flows can have links");
        }
        ManagedBeanState state = this.stateMap.get(managedBean);
        if (state == null) {
            state = new ManagedBeanState();
            this.stateMap.put((ManagedBeanImpl)managedBean, state);
        } else if (state.isRemoved()) {
            throw new IllegalStateException("Managed bean has been removed");
        }
        state.addLink(linkName, taskFlowName);
    }

    @Override
    public final Pair<String, String> removeLink(IWebPageContext.IManagedBean managedBean) {
        assert (managedBean != null);
        if (!this.isBoundToTaskFlow(managedBean)) {
            throw new IllegalStateException("Only used managed beans can have links");
        }
        ManagedBeanState state = this.stateMap.get(managedBean);
        if (state == null) {
            throw new IllegalStateException("Cannot remove links unless they were added by this manager.");
        }
        if (state.isRemoved()) {
            throw new IllegalStateException("Managed bean has been removed");
        }
        Pair pair = state.removeLink();
        if (pair == null) {
            throw new IllegalStateException("All links have already been removed");
        }
        return pair;
    }

    @Override
    public boolean isValidTaskFlowBindName(IWebPageContext.IManagedBean managedBean, String name) throws Exception {
        ManagedBeanState state = this.stateMap.get(managedBean);
        return state == null || state.getTaskFlowBind() == null || !((String)state.getTaskFlowBind().getFirst()).equals(name);
    }

    @Override
    public boolean isValidLinkName(IWebPageContext.IManagedBean managedBean, String linkName, String taskFlowName) throws Exception {
        ManagedBeanState state = this.stateMap.get(managedBean);
        if (state != null && state.addedLinks != null && !state.addedLinks.isEmpty()) {
            for (Pair link : state.addedLinks) {
                if (!((String)link.getFirst()).equals(linkName)) continue;
                return !((String)link.getSecond()).equals(taskFlowName);
            }
        }
        return true;
    }

    protected abstract IOEPEExecutableContext.IContextSaveParticipant getSaveParticipant(Map<ManagedBeanImpl, ManagedBeanState> var1);

    private class ContextAdapter
    extends ExecutableContextAdapter {
        private ContextAdapter() {
        }

        @Override
        public void handleDispose(IOEPEContext context) {
            ManagedBeanManagerImpl.this.dispose();
        }

        @Override
        public void handleReset(IOEPEContext context) {
            ManagedBeanManagerImpl.this.reset();
        }

        @Override
        public IOEPEExecutableContext.IContextSaveParticipant handlePreSave(IOEPEExecutableContext context) {
            Map<ManagedBeanImpl, ManagedBeanState> snapshot = ManagedBeanManagerImpl.this.getSnapshot();
            return !snapshot.isEmpty() ? ManagedBeanManagerImpl.this.getSaveParticipant(snapshot) : null;
        }
    }

    public static final class ManagedBeanState
    implements Cloneable {
        private boolean added;
        private boolean removed;
        private Pair<String, String> taskFlowBind;
        private Pair<String, String> removedTaskFlowBind;
        private List<Pair<String, String>> addedLinks;
        private List<Pair<String, String>> removedLinks;
        private ManagedBeanState originalState;

        private ManagedBeanState() {
        }

        private void add() {
            assert (!this.added);
            this.added = true;
            this.removed = false;
        }

        public boolean isAdded() {
            return this.added;
        }

        private void remove() {
            assert (this.added);
            assert (!this.removed);
            this.added = false;
            this.removed = true;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        private void setTaskFlowBind(String bindName, String taskFlowName) {
            if (bindName == null) {
                assert (this.taskFlowBind != null);
                assert (taskFlowName == null);
                this.removedTaskFlowBind = new Pair((Object)((String)this.taskFlowBind.getFirst()), (Object)((String)this.taskFlowBind.getSecond()));
                this.taskFlowBind = null;
            } else {
                assert (taskFlowName != null);
                this.removedTaskFlowBind = null;
                this.taskFlowBind = new Pair((Object)bindName, (Object)taskFlowName);
            }
        }

        public Pair<String, String> getTaskFlowBind() {
            return this.taskFlowBind != null ? this.taskFlowBind : this.removedTaskFlowBind;
        }

        public Boolean getBoundToTaskFlow() {
            return this.taskFlowBind == null && this.removedTaskFlowBind == null ? null : Boolean.valueOf(this.taskFlowBind != null);
        }

        private void addLink(String linkName, String taskFlowName) {
            Pair<String, String> link2;
            if (this.addedLinks == null) {
                this.addedLinks = new ArrayList<Pair<String, String>>();
            } else {
                for (Pair<String, String> link2 : this.addedLinks) {
                    if (!linkName.equals(link2.getFirst()) || taskFlowName.equals(link2.getSecond())) continue;
                    throw new IllegalArgumentException(String.format("The link '%s' is already associated with the task flow '%s' and cannot be used with '%s'", linkName, link2.getSecond(), taskFlowName));
                }
            }
            link2 = new Pair<String, String>((Object)linkName, (Object)taskFlowName);
            if (this.removedLinks != null) {
                while (this.removedLinks.remove(link2)) {
                }
                if (this.removedLinks.isEmpty()) {
                    this.removedLinks = null;
                }
            }
            this.addedLinks.add(link2);
        }

        private Pair<String, String> removeLink() {
            if (this.addedLinks != null && !this.addedLinks.isEmpty()) {
                Pair<String, String> link = this.addedLinks.remove(this.addedLinks.size() - 1);
                boolean addToRemovedList = true;
                if (this.addedLinks.isEmpty()) {
                    this.addedLinks = null;
                } else {
                    boolean bl = addToRemovedList = !this.addedLinks.contains(link);
                }
                if (addToRemovedList) {
                    if (this.removedLinks == null) {
                        this.removedLinks = new ArrayList<Pair<String, String>>();
                    }
                    this.removedLinks.add(link);
                }
                return link;
            }
            return null;
        }

        public List<? extends Pair<String, String>> getAddedLinks() {
            return this.reverseList(this.addedLinks);
        }

        public List<? extends Pair<String, String>> getRemovedLinks() {
            return this.reverseList(this.removedLinks);
        }

        private List<? extends Pair<String, String>> reverseList(List<Pair<String, String>> list) {
            if (list != null && !list.isEmpty()) {
                ArrayList<Pair<String, String>> clone = new ArrayList<Pair<String, String>>(list);
                Collections.reverse(clone);
                return Collections.unmodifiableList(clone);
            }
            return Collections.emptyList();
        }

        public ManagedBeanState clone() {
            ManagedBeanState clone = new ManagedBeanState();
            clone.added = this.added;
            clone.removed = this.removed;
            clone.taskFlowBind = this.taskFlowBind;
            clone.removedTaskFlowBind = this.removedTaskFlowBind;
            if (this.addedLinks != null) {
                clone.addedLinks = new ArrayList<Pair<String, String>>(this.addedLinks);
            }
            if (this.removedLinks != null) {
                clone.removedLinks = new ArrayList<Pair<String, String>>(this.removedLinks);
            }
            clone.originalState = this.originalState == null ? this : this.originalState;
            return clone;
        }
    }
}

