/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.internal.DTRTBundle;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;

public final class JavaUtil {
    private JavaUtil() {
    }

    public static String toJavaIdentifier(String text, char replacementCharacter) {
        if (!DTRTUtil.isEmpty(text)) {
            StringBuilder identifier = new StringBuilder();
            int textLength = text.length();
            int i = 0;
            while (i < textLength) {
                int cp = text.codePointAt(i);
                if (cp == 47) {
                    identifier.append('.');
                } else if (Character.isJavaIdentifierPart(cp)) {
                    identifier.appendCodePoint(cp);
                } else if (replacementCharacter != '@') {
                    identifier.append(replacementCharacter);
                }
                i += Character.charCount(cp);
            }
            return identifier.toString();
        }
        return text;
    }

    public static String toJavaIdentifier(String text) {
        return JavaUtil.toJavaIdentifier(text, '@');
    }

    public static String toFieldName(String baseName, boolean finalStatic, Collection<String> existingFieldNames) {
        return JavaUtil.toFieldName(null, baseName, finalStatic, existingFieldNames);
    }

    public static String toFieldName(IProject project, String baseName, boolean staticFinal, Collection<String> existingNames) {
        if (baseName != null) {
            String[] excluded;
            IJavaProject javaProject;
            int variableKind = staticFinal ? 3 : 2;
            String[] names = NamingConventions.suggestVariableNames((int)variableKind, (int)1, (String)(baseName = JavaUtil.toJavaIdentifier(baseName)), (IJavaProject)(javaProject = project != null ? JavaCore.create((IProject)project) : null), (int)0, (String[])(excluded = existingNames != null ? existingNames.toArray(new String[existingNames.size()]) : null), (boolean)true);
            if (names == null || names.length == 0) {
                names = NamingConventions.suggestVariableNames((int)variableKind, (int)2, (String)baseName, (IJavaProject)javaProject, (int)0, (String[])excluded, (boolean)true);
            }
            if (names != null && names.length > 0) {
                return names[0];
            }
        }
        return null;
    }

    public static String toGetterName(String baseName, boolean booleanReturn, Collection<String> existingNames) {
        return JavaUtil.toGetterName(null, baseName, booleanReturn, existingNames);
    }

    public static String toGetterName(IProject project, String baseName, boolean booleanReturn, Collection<String> existingNames) {
        if (baseName != null) {
            baseName = JavaUtil.toJavaIdentifier(baseName);
            IJavaProject javaProject = project != null ? JavaCore.create((IProject)project) : null;
            String[] excluded = existingNames != null ? existingNames.toArray(new String[existingNames.size()]) : null;
            return NamingConventions.suggestGetterName((IJavaProject)javaProject, (String)baseName, (int)2, (boolean)booleanReturn, (String[])excluded);
        }
        return null;
    }

    public static Pair<Set<String>, Set<String>> collectMemberNames(Class<?> cls) {
        HashSet<String> fieldNames = new HashSet<String>();
        HashSet<String> methodNames = new HashSet<String>();
        try {
            JavaUtil.collectMemberNames(fieldNames, methodNames, cls, false);
        }
        catch (Exception e) {
            DTRTBundle.log(e);
        }
        return new Pair(fieldNames, methodNames);
    }

    private static void collectMemberNames(Set<String> fieldNames, Set<String> methodNames, Class<?> cls, boolean superClass) {
        if (cls != null) {
            int modifier;
            AccessibleObject[] accessibleObjectArray = cls.getDeclaredFields();
            int n = accessibleObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = accessibleObjectArray[n2];
                if (superClass) {
                    modifier = field.getModifiers();
                    if (Modifier.isPublic(modifier) || Modifier.isProtected(modifier)) {
                        fieldNames.add(field.getName());
                    }
                } else {
                    fieldNames.add(field.getName());
                }
                ++n2;
            }
            accessibleObjectArray = cls.getDeclaredMethods();
            n = accessibleObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                AccessibleObject methods = accessibleObjectArray[n2];
                if (superClass) {
                    modifier = ((Method)methods).getModifiers();
                    if (Modifier.isPublic(modifier) || Modifier.isProtected(modifier)) {
                        methodNames.add(((Method)methods).getName());
                    }
                } else {
                    methodNames.add(((Method)methods).getName());
                }
                ++n2;
            }
            JavaUtil.collectMemberNames(fieldNames, methodNames, cls.getSuperclass(), true);
        }
    }

    public static String computeSourcePath(IFile file, String knownSourceFolderName) {
        if (file != null) {
            IFolder defaultSourceFolder;
            IProject project = file.getProject();
            String sourcePath = null;
            if (knownSourceFolderName != null && (defaultSourceFolder = project.getFolder(knownSourceFolderName)).getFullPath().isPrefixOf(file.getFullPath())) {
                sourcePath = JavaUtil.computeRelativePath((IContainer)defaultSourceFolder, file);
            }
            if (sourcePath == null && JavaProjectUtil.isJavaProject((IProject)project)) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = JavaUtil.getPackageFragmentRoots(project);
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer sourceContainer;
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    IResource packageFragmentRootResource = packageFragmentRoot.getResource();
                    if (packageFragmentRootResource instanceof IContainer && (sourcePath = JavaUtil.computeRelativePath(sourceContainer = (IContainer)packageFragmentRootResource, file)) != null) break;
                    ++n2;
                }
            }
            return sourcePath;
        }
        return null;
    }

    private static String computeRelativePath(IContainer container, IFile file) {
        IPath relativePath;
        IPath fullPath = file.getFullPath();
        return !fullPath.equals((Object)(relativePath = fullPath.makeRelativeTo(container.getFullPath()))) ? relativePath.toString() : null;
    }

    public static void ensureIsSourceFile(IFile file, String knownSourceFolderName) throws CoreException {
        IJavaProject javaProject;
        assert (file.isAccessible());
        IProject project = file.getProject();
        if (JavaProjectUtil.isJavaProject((IProject)project) && (javaProject = JavaCore.create((IProject)project)) != null) {
            IFolder defaultSourceFolder;
            IPath defaultSourceFolderPath;
            if (javaProject.isOnClasspath((IResource)file)) {
                return;
            }
            if (knownSourceFolderName != null && (defaultSourceFolderPath = (defaultSourceFolder = project.getFolder(knownSourceFolderName)).getFullPath()).isPrefixOf(file.getFullPath())) {
                oracle.eclipse.tools.common.util.jdt.JavaUtil.addToClasspath((IJavaProject)JavaCore.create((IProject)project), (IClasspathEntry)JavaCore.newSourceEntry((IPath)defaultSourceFolder.getFullPath()));
                return;
            }
        }
        throw new CoreException(DTRTUtil.createErrorStatus("Unable to create a source folder for '%s'", file.getFullPath()));
    }

    public static IFile getSourceFile(IProject project, String path, boolean createFileHandle, String knownSourceFolderName) throws RuntimeException {
        if (!DTRTUtil.isEmpty(path) && project != null && project.isAccessible() && JavaProjectUtil.isJavaProject((IProject)project)) {
            IFile sourceFile = null;
            IPackageFragmentRoot[] iPackageFragmentRootArray = JavaUtil.getPackageFragmentRoots(project);
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                IResource packageFragmentRootResource = packageFragmentRoot.getResource();
                if (packageFragmentRootResource instanceof IContainer) {
                    IContainer sourceContainer = (IContainer)packageFragmentRootResource;
                    if (sourceFile == null || knownSourceFolderName != null && knownSourceFolderName.equals(sourceContainer.getName())) {
                        IResource member = sourceContainer.findMember(path);
                        if (member instanceof IFile && sourceFile == null) {
                            sourceFile = (IFile)member;
                        }
                        if (sourceFile != null && knownSourceFolderName != null && knownSourceFolderName.equals(sourceContainer.getName())) break;
                    }
                }
                ++n2;
            }
            if (sourceFile == null && createFileHandle && knownSourceFolderName != null) {
                IFolder sourceFolder = project.getFolder(knownSourceFolderName);
                sourceFile = sourceFolder.getFile(path);
            }
            return sourceFile;
        }
        return null;
    }

    public static IFile getClasspathEntryFile(IProject project, String fullName, String fileExtension, boolean createFileHandle, String knownSourceFolderName) throws IllegalArgumentException, RuntimeException {
        if (!DTRTUtil.isEmpty(fullName) && project != null && project.isAccessible() && JavaProjectUtil.isJavaProject((IProject)project)) {
            String fileSuffix = fileExtension != null ? (fileExtension.charAt(0) == '.' ? fileExtension : String.valueOf('.') + fileExtension) : "";
            String classpathEntryPackage = null;
            String fileName = null;
            int index = fullName.lastIndexOf(46);
            if (index > 0 && index < fullName.length() - 1) {
                classpathEntryPackage = fullName.substring(0, index);
                fileName = String.valueOf(fullName.substring(index + 1)) + fileSuffix;
            } else if (index < 0) {
                fileName = String.valueOf(fullName) + fileSuffix;
            } else {
                throw new IllegalArgumentException("Invalid full name: " + fullName);
            }
            IFile classpathEntryFile = null;
            IPackageFragmentRoot[] iPackageFragmentRootArray = JavaUtil.getPackageFragmentRoots(project);
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                IResource packageFragmentRootResource = packageFragmentRoot.getResource();
                if (packageFragmentRootResource instanceof IContainer) {
                    IContainer sourceContainer = (IContainer)packageFragmentRootResource;
                    if (classpathEntryFile == null || knownSourceFolderName != null && knownSourceFolderName.equals(sourceContainer.getName())) {
                        IResource member = null;
                        if (classpathEntryPackage == null) {
                            member = sourceContainer.findMember(fileName);
                        } else {
                            IResource packageFragmentResource;
                            IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(classpathEntryPackage);
                            if (packageFragment.exists() && (packageFragmentResource = packageFragment.getResource()) instanceof IContainer) {
                                member = ((IContainer)packageFragmentResource).findMember(fileName);
                            }
                        }
                        if (member instanceof IFile) {
                            classpathEntryFile = (IFile)member;
                        }
                        if (classpathEntryFile != null && knownSourceFolderName != null && knownSourceFolderName.equals(sourceContainer.getName())) break;
                    }
                }
                ++n2;
            }
            if (classpathEntryFile == null && createFileHandle && knownSourceFolderName != null) {
                IFolder sourceFolder = project.getFolder(knownSourceFolderName);
                String path = JavaUtil.computePath(fullName, fileExtension);
                classpathEntryFile = sourceFolder.getFile(path);
            }
            return classpathEntryFile;
        }
        return null;
    }

    private static IPackageFragmentRoot[] getPackageFragmentRoots(IProject project) {
        IPackageFragmentRoot[] packageFragmentRoots;
        try {
            packageFragmentRoots = JavaCore.create((IProject)project).getPackageFragmentRoots();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        return packageFragmentRoots == null ? new IPackageFragmentRoot[]{} : packageFragmentRoots;
    }

    private static String computePath(String fullName, String fileExtension) {
        if (fullName != null) {
            fileExtension = fileExtension != null && fileExtension.charAt(0) != '.' ? String.valueOf('.') + fileExtension : "";
            StringBuilder sb = new StringBuilder(1 + fullName.length() + fileExtension.length());
            sb.append(fullName.replace('.', '/')).append(fileExtension);
            return sb.toString();
        }
        return null;
    }

    public static Class<?> getPrimitiveOrVoidType(String typeName) {
        return Boolean.TYPE.getName().equals(typeName) ? Boolean.TYPE : (Byte.TYPE.getName().equals(typeName) ? Byte.TYPE : (Character.TYPE.getName().equals(typeName) ? Character.TYPE : (Double.TYPE.getName().equals(typeName) ? Double.TYPE : (Integer.TYPE.getName().equals(typeName) ? Integer.TYPE : (Float.TYPE.getName().equals(typeName) ? Float.TYPE : (Long.TYPE.getName().equals(typeName) ? Long.TYPE : (Short.TYPE.getName().equals(typeName) ? Short.TYPE : (Void.TYPE.getName().equals(typeName) ? Void.TYPE : null))))))));
    }

    public static String toSimpleName(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) > 0 && index < name.length() - 2) {
            return name.substring(index + 1);
        }
        return name;
    }

    public static String[] computeDottedNames(String name) {
        if (!DTRTUtil.isEmpty(name)) {
            ArrayList<String> list = new ArrayList<String>();
            int index = name.indexOf(46);
            while (index > 0 && index < name.length() - 1) {
                String substring = name.substring(0, index);
                if (substring.length() > 0) {
                    list.add(substring);
                }
                index = name.indexOf(46, index + 1);
            }
            if (list.isEmpty()) {
                return new String[]{name};
            }
            list.add(name);
            Collections.reverse(list);
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }
}

