/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import oracle.eclipse.tools.adf.dtrt.util.BasicDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;

public enum DTRTContentType implements IDescribable
{
    ADF_REGISTRY("adfm.metainf", Messages.registryLabel, Messages.registryTooltip, null),
    CONFIGURATION("adfm.configuration", Messages.configurationLabel, Messages.configurationTooltip, DTRTBundleIcon.DATA_CONTROL_GENERIC),
    BEAN_STRUCTURE("adfm.beanmodel", Messages.beanStructureLabel, Messages.beanStructureTooltip, null),
    APPLICATION("adfm.application", Messages.applicationLabel, Messages.applicationTooltip, DTRTBundleIcon.APPLICATION),
    PAGE_DEFINITION("adfm.pagedefinition", Messages.pageDefinitionLabel, Messages.pageDefinitionTooltip, DTRTBundleIcon.PAGE_DEFINITION),
    PDEF_VIEW_OBJECT("adfm.pdefviewobject", Messages.pdefViewObjectLabel, Messages.pdefViewObjectTooltip, null);

    private final String id;
    private BasicDescriptor descriptor;

    private static String getContentTypeId(IFile file) {
        if (file != null) {
            try {
                IContentType contentType;
                IContentDescription description = file.getContentDescription();
                if (description != null && (contentType = description.getContentType()) != null) {
                    return contentType.getId();
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public static DTRTContentType getDTRTContentType(IFile file) {
        String id = DTRTContentType.getContentTypeId(file);
        if (id != null) {
            DTRTContentType[] dTRTContentTypeArray = DTRTContentType.values();
            int n = dTRTContentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DTRTContentType type = dTRTContentTypeArray[n2];
                if (type.getId().equals(id)) {
                    return type;
                }
                ++n2;
            }
        }
        return null;
    }

    private DTRTContentType(String id, String label, String toolTipText, ImageManager.IImageData imageData) {
        this.id = id;
        this.descriptor = new BasicDescriptor(label, toolTipText, imageData);
    }

    public String getId() {
        return this.id;
    }

    public boolean appliesTo(IFile file) {
        return this.getId().equals(DTRTContentType.getContentTypeId(file));
    }

    public boolean isXML(IFile file) {
        return true;
    }

    @Override
    public IDescriptor getDescriptor() {
        return this.descriptor;
    }

    private static class Messages
    extends NLS {
        public static String registryLabel;
        public static String registryTooltip;
        public static String configurationLabel;
        public static String configurationTooltip;
        public static String beanStructureLabel;
        public static String beanStructureTooltip;
        public static String applicationLabel;
        public static String applicationTooltip;
        public static String pageDefinitionLabel;
        public static String pageDefinitionTooltip;
        public static String pdefViewObjectLabel;
        public static String pdefViewObjectTooltip;

        static {
            NLS.initializeMessages((String)DTRTContentType.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

