/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IObjectLocatorContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;

public final class ContextCache {
    private static volatile ContextCache instance;
    private Map<CacheKey<?>, IOEPEContext> map = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContextCache getInstance() {
        if (instance != null) return instance;
        Class<ContextCache> clazz = ContextCache.class;
        synchronized (ContextCache.class) {
            if (instance != null) return instance;
            instance = new ContextCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ContextCache() {
    }

    public void clear() {
        this.map.clear();
    }

    public <T extends IOEPEContext> T put(Object key, T context) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (context == null || context.isDisposed()) {
            throw new IllegalArgumentException("The context cannot be null nor disposed");
        }
        CacheKey<T> cacheKey = this.createCacheKey(context, key);
        return (T)(DTRTUtil.isNotDisposed(context = cacheKey.getType().cast(this.map.put(cacheKey, context))) ? context : null);
    }

    public <T extends IOEPEContext> T putIfAbsent(Object key, T context) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (context == null || context.isDisposed()) {
            throw new IllegalArgumentException("The context cannot be null nor disposed");
        }
        CacheKey<T> cacheKey = this.createCacheKey(context, key);
        T cachedContext = this.get(cacheKey);
        if (cachedContext == null) {
            this.map.put(cacheKey, context);
        }
        return cachedContext;
    }

    public <T extends IOEPEContext> T remove(Class<T> type, Object key) {
        CacheKey<T> cacheKey = new CacheKey<T>(type, key);
        T context = this.get(cacheKey);
        if (context != null) {
            this.map.remove(cacheKey);
        }
        return context;
    }

    public <T extends IOEPEContext> T get(Class<T> type, Object key) {
        return type != null ? (T)this.get(new CacheKey<T>(type, key)) : null;
    }

    private <T extends IOEPEContext> T get(CacheKey<T> cacheKey) {
        IOEPEContext context = this.map.get(cacheKey);
        if (context != null && context.isDisposed()) {
            this.map.remove(cacheKey);
            context = null;
        }
        return (T)((IOEPEContext)cacheKey.getType().cast(context));
    }

    private <T extends IOEPEContext> CacheKey<T> createCacheKey(T context, Object key) {
        Class<IWebPageContext> type;
        Class clazz = context instanceof IWebPageContext ? IWebPageContext.class : (context instanceof IPageDefinitionContext ? IPageDefinitionContext.class : (context instanceof ITaskFlowContext ? ITaskFlowContext.class : (context instanceof IDataControlContext ? IDataControlContext.class : (type = context instanceof IObjectLocatorContext ? IObjectLocatorContext.class : null))));
        if (type == null) {
            throw new IllegalArgumentException("Unsupported context type: " + context);
        }
        return new CacheKey<IWebPageContext>(type, key);
    }

    private static final class CacheKey<T extends IOEPEContext> {
        private final Class<T> type;
        private final Object key;

        public CacheKey(Class<T> type, Object key) {
            this.type = type;
            this.key = key;
        }

        public Class<T> getType() {
            return this.type;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.type == other.type && DTRTUtil.equals(this.key, other.key);
        }
    }
}

