/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CompoundList<E>
extends AbstractList<E> {
    private List<List<? extends E>> lists;
    private int size = -1;

    public CompoundList(List<? extends E> list) {
        this(Collections.singleton(list));
    }

    public CompoundList(List<? extends E> list1, List<? extends E> list2) {
        this((Collection<List<E>>)Arrays.asList(list1, list2));
    }

    public CompoundList(List<? extends E> list1, List<? extends E> list2, List<? extends E> list3) {
        this((Collection<List<E>>)Arrays.asList(list1, list2, list3));
    }

    public CompoundList(List<? extends E> ... lists) {
        this((Collection<List<? extends E>>)Arrays.asList(lists));
    }

    private CompoundList(Collection<? extends List<? extends E>> lists) {
        this.lists = Collections.unmodifiableList(new ArrayList<List<? extends E>>(lists));
    }

    @Override
    public int size() {
        if (this.size < 0) {
            this.size = 0;
            for (List<E> list : this.lists) {
                this.size += list.size();
            }
        }
        return this.size;
    }

    @Override
    public E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        if (this.size >= 0 && index >= this.size) {
            throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", index, this.size));
        }
        int size = 0;
        Iterator<List<E>> iterator = this.lists.iterator();
        while (iterator.hasNext()) {
            int adjustedIndex = index - size;
            List<E> list = iterator.next();
            if (adjustedIndex < list.size()) {
                return list.get(adjustedIndex);
            }
            size += list.size();
        }
        this.size = size;
        throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", index, size));
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }
}

