/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import oracle.eclipse.tools.adf.dtrt.util.BaseDescribable;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;

public abstract class BaseDescribableDecorator<T>
extends BaseDescribable {
    private T decoratedObject;
    private String label;

    protected BaseDescribableDecorator(T decoratedObject) {
        this.decoratedObject = decoratedObject;
        if (decoratedObject == null) {
            throw new IllegalArgumentException("The decorated object cannot be null");
        }
    }

    protected BaseDescribableDecorator(T decoratedObject, String label) {
        this(decoratedObject);
        this.label = label;
    }

    @Override
    public void dispose() {
        this.decoratedObject = null;
        super.dispose();
    }

    public final boolean isDisposed() {
        return this.decoratedObject == null;
    }

    @Override
    protected final BaseDescriptor createDescriptor() {
        return this.getLabel() == null ? null : new BaseDescriptor(){

            @Override
            public String getLabel() {
                return BaseDescribableDecorator.this.getLabel();
            }

            @Override
            public String getToolTipText() {
                return BaseDescribableDecorator.this.getToolTipText();
            }

            @Override
            public ImageManager.IImageData getImageData() {
                return BaseDescribableDecorator.this.getImageData();
            }
        };
    }

    public final T getDecoratedObject() {
        return this.decoratedObject;
    }

    protected final void setLabel(String label) {
        this.label = label;
    }

    protected String getLabel() {
        return this.label;
    }

    protected String getToolTipText() {
        return null;
    }

    protected ImageManager.IImageData getImageData() {
        return null;
    }

    protected final int baseDecoratorHashCode() {
        int result = this.baseHashCode();
        result = 31 * result + (this.getDecoratedObject() == null ? 0 : this.getDecoratedObject().hashCode());
        return result;
    }

    protected final boolean baseDecoratorEquals(Object obj) {
        return this.baseEquals(obj) && DTRTUtil.equals(this.getDecoratedObject(), ((BaseDescribableDecorator)obj).getDecoratedObject());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        builder.append("label=");
        builder.append(DTRTUtil.getLabel(this.getDescriptor()));
        builder.append(", decoratedObject=");
        builder.append(this.getDecoratedObject());
        builder.append("]");
        return builder.toString();
    }
}

