/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.usage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.usage.BindingObjectUsageManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class SSEDocumentProvider
implements BindingObjectUsageManager.IBoundSourceDocumentProvider {
    protected Map<IFile, Set<BindingObjectUsageManager>> usageManagersByFile = new HashMap<IFile, Set<BindingObjectUsageManager>>();

    protected static String getNodeProxyLabel(Node node) {
        return node != null ? node.getNodeName() : null;
    }

    protected SSEDocumentProvider() {
    }

    protected abstract IDOMModel getDOMModel(IFile var1) throws Exception;

    protected abstract void monitor(BindingObjectUsageManager var1, IFile var2, IDOMModel var3);

    protected abstract void stopMonitoring(IFile var1, boolean var2);

    @Override
    public final void usageManagerDisposed(BindingObjectUsageManager usageManager) {
        this.stopMonitoring(usageManager, true);
    }

    @Override
    public final void usageManagerReset(BindingObjectUsageManager usageManager) {
        this.stopMonitoring(usageManager, false);
    }

    private void stopMonitoring(BindingObjectUsageManager usageManager, boolean userManagerDisposed) {
        Iterator<Map.Entry<IFile, Set<BindingObjectUsageManager>>> i = this.usageManagersByFile.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IFile, Set<BindingObjectUsageManager>> entry = i.next();
            if (!entry.getValue().remove(usageManager) || !entry.getValue().isEmpty()) continue;
            i.remove();
            this.stopMonitoring(entry.getKey(), userManagerDisposed);
        }
    }

    @Override
    public final Document loadDocument(BindingObjectUsageManager usageManager, IFile xmlFile) throws Exception {
        IDOMDocument document;
        IDOMModel model = this.getDOMModel(xmlFile);
        if (model != null && (document = model.getDocument()).getDocumentElement() != null) {
            Set<BindingObjectUsageManager> fileUsageManagers = this.usageManagersByFile.get(xmlFile);
            if (fileUsageManagers == null) {
                fileUsageManagers = new HashSet<BindingObjectUsageManager>();
                this.usageManagersByFile.put(xmlFile, fileUsageManagers);
            }
            if (fileUsageManagers.add(usageManager)) {
                this.monitor(usageManager, xmlFile, model);
            }
            return document;
        }
        return null;
    }

    @Override
    public final void nodeProxiesCreated(BindingObjectUsageManager usageManager, IFile xmlFile, Document document) throws Exception {
        ((IDOMDocument)document).getModel().releaseFromRead();
    }
}

