/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.usage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.internal.DTRTBundle;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.usage.BindingObjectUsageManager;
import oracle.eclipse.tools.adf.dtrt.usage.SSEDocumentProvider;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.SSEMonitor;
import oracle.eclipse.tools.adf.dtrt.util.SSEUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class LiveMonitoringProvider
extends SSEDocumentProvider {
    private Map<IFile, SSEMonitorAdapter> monitorAdaptersByFile = new HashMap<IFile, SSEMonitorAdapter>();

    private static boolean mayUseBindingObject(String value) {
        return value != null && value.contains("bindings.");
    }

    @Override
    protected IDOMModel getDOMModel(IFile xmlFile) throws Exception {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(xmlFile);
        if (model instanceof IDOMModel) {
            return (IDOMModel)model;
        }
        DTRTBundle.log((IStatus)new Status(2, "oracle.eclipse.tools.adf.dtrt", "LiveMonitoringProvider: Unable to get an existing model for " + xmlFile));
        return null;
    }

    @Override
    protected void monitor(BindingObjectUsageManager usageManager, IFile xmlFile, IDOMModel model) {
        SSEMonitorAdapter monitorAdapter = this.monitorAdaptersByFile.get(xmlFile);
        if (monitorAdapter == null) {
            this.monitorAdaptersByFile.put(xmlFile, new SSEMonitorAdapter(usageManager, xmlFile, model.getDocument()));
        } else {
            assert (!monitorAdapter.isEnabled()) : xmlFile;
            monitorAdapter.setEnabled(true);
        }
    }

    @Override
    protected void stopMonitoring(IFile xmlFile, boolean userManagerDisposed) {
        if (userManagerDisposed) {
            SSEMonitorAdapter monitorAdapter = this.monitorAdaptersByFile.remove(xmlFile);
            if (monitorAdapter != null) {
                monitorAdapter.dispose();
            }
        } else {
            SSEMonitorAdapter monitorAdapter = this.monitorAdaptersByFile.get(xmlFile);
            if (monitorAdapter != null) {
                monitorAdapter.setEnabled(false);
            }
        }
    }

    @Override
    public BindingObjectUsageManager.INodeProxy createNodeProxy(BindingObjectUsageManager usageManager, IPageDefinition.IBoundSource boundSource, Node node) {
        return this.createNodeProxy(boundSource, (IDOMNode)node);
    }

    public BindingObjectUsageManager.INodeProxy createNodeProxy(IPageDefinition.IBoundSource boundSource, IDOMNode node) {
        return new NodeProxy(boundSource, node);
    }

    public List<? extends BindingObjectUsageManager.Usage> computeUsages(BindingObjectUsageManager usageManager, IFile boundSourceFile, IDOMNode node, boolean stopAtFirstUsage) {
        if (usageManager != null) {
            ArrayList<? extends BindingObjectUsageManager.Usage> list = new ArrayList<BindingObjectUsageManager.Usage>();
            for (IPageDefinition.IBoundSource iBoundSource : BindingObjectUsageManager.getBoundSources(usageManager, boundSourceFile, null)) {
                list.addAll(usageManager.getUsages(iBoundSource, (Node)node));
                if (stopAtFirstUsage && !list.isEmpty()) break;
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private static class NodeProxy
    implements BindingObjectUsageManager.INodeProxy {
        private IPageDefinition.IBoundSource boundSource;
        private IDOMNode node;

        public NodeProxy(IPageDefinition.IBoundSource boundSource, IDOMNode node) {
            assert (boundSource != null);
            assert (node != null);
            this.boundSource = boundSource;
            this.node = node;
        }

        @Override
        public void dipose() {
            this.boundSource = null;
            this.node = null;
        }

        @Override
        public boolean isDisposed() {
            return this.boundSource == null;
        }

        @Override
        public IPageDefinition.IBoundSource getBoundSource() {
            return this.boundSource;
        }

        @Override
        public boolean represents(Node node) {
            return node instanceof IDOMNode && this.equals(new NodeProxy(this.getBoundSource(), (IDOMNode)node));
        }

        @Override
        public String getLabel() {
            return this.isDisposed() ? null : LiveMonitoringProvider.getNodeProxyLabel((Node)this.node);
        }

        @Override
        public int getStartPosition() {
            return this.isDisposed() ? -1 : this.node.getStartOffset();
        }

        @Override
        public int getEndPosition() {
            return this.isDisposed() ? -1 : this.node.getEndOffset();
        }

        @Override
        public int getStartLine() {
            int[] lines;
            if (!this.isDisposed() && (lines = SSEUtil.computeLineNumbers(this.node)) != null) {
                return lines[0];
            }
            return -1;
        }

        @Override
        public int getEndLine() {
            int[] lines;
            if (!this.isDisposed() && (lines = SSEUtil.computeLineNumbers(this.node)) != null) {
                return lines[1];
            }
            return -1;
        }

        @Override
        public int hashCode() {
            if (!this.isDisposed()) {
                int result = 1;
                result = 31 * result + (this.getLabel() == null ? 0 : this.getLabel().hashCode());
                result = 31 * result + (this.boundSource == null ? 0 : this.boundSource.hashCode());
                result = 31 * result + this.getStartPosition();
                result = 31 * result + this.getEndPosition();
                return result;
            }
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (!this.isDisposed()) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof NodeProxy)) {
                    return false;
                }
                NodeProxy other = (NodeProxy)obj;
                return this.getStartPosition() == other.getStartPosition() && this.getEndPosition() == other.getEndPosition() && DTRTUtil.equals(this.getLabel(), other.getLabel()) && DTRTUtil.equals(this.boundSource, other.boundSource);
            }
            return super.equals(obj);
        }

        @Override
        public String toString() {
            if (!this.isDisposed()) {
                return BindingObjectUsageManager.toString(this);
            }
            return super.toString();
        }
    }

    private class SSEMonitorAdapter
    extends SSEMonitor.SSEAdapter {
        private BindingObjectUsageManager usageManager;
        private IFile boundSourceFile;
        private SSEMonitor monitor;
        private boolean enabled;

        public SSEMonitorAdapter(BindingObjectUsageManager usageManager, IFile boundSourceFile, IDOMDocument document) {
            assert (usageManager != null);
            assert (boundSourceFile != null);
            this.usageManager = usageManager;
            this.boundSourceFile = boundSourceFile;
            this.monitor = new SSEMonitor();
            this.monitor.addListener(this);
            this.monitor.start(document, boundSourceFile);
            this.enabled = true;
        }

        public void dispose() {
            if (this.monitor != null) {
                this.monitor.dispose();
                this.monitor = null;
            }
            this.enabled = false;
            this.usageManager = null;
            this.boundSourceFile = null;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void handleAdd(IDOMNode parent, IDOMElement newElement) {
            if (this.enabled && LiveMonitoringProvider.mayUseBindingObject(newElement.toString())) {
                this.usageManager.reset();
            }
        }

        @Override
        public void handleRemove(IDOMNode parent, IDOMElement removedElement) {
            if (this.enabled && !LiveMonitoringProvider.this.computeUsages(this.usageManager, this.boundSourceFile, (IDOMNode)removedElement, true).isEmpty()) {
                this.usageManager.reset();
            }
        }

        @Override
        public void handleAttributeChange(IDOMElement element, IDOMAttr attribute, String oldValue, String newValue) {
            if (this.enabled && this.usageManager != null && (LiveMonitoringProvider.mayUseBindingObject(oldValue) || LiveMonitoringProvider.mayUseBindingObject(newValue) || !LiveMonitoringProvider.this.computeUsages(this.usageManager, this.boundSourceFile, (IDOMNode)element, true).isEmpty())) {
                this.usageManager.reset();
            }
        }

        @Override
        public void modelReverted(IStructuredModel model, IFile file) {
            if (this.enabled) {
                this.usageManager.reset();
            }
        }
    }
}

