/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.locator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IObjectLocatorContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.locator.IObjectLocator;
import oracle.eclipse.tools.adf.dtrt.locator.SynchronizedObjectLocator;
import oracle.eclipse.tools.adf.dtrt.object.IApplication;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public final class ObjectLocatorManager
implements IObjectLocator {
    private boolean disposed;
    private TypedListenerList<IOEPEContext.IContextListener> listeners = new TypedListenerList();
    private Map<MapKey, IObjectLocator> objectLocatorMap = new HashMap<MapKey, IObjectLocator>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        Map<MapKey, IObjectLocator> map = this.objectLocatorMap;
        synchronized (map) {
            for (IObjectLocator objectLocator : this.objectLocatorMap.values()) {
                objectLocator.dispose();
            }
            this.objectLocatorMap.clear();
        }
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProject getCachedEARProject(IProject project) {
        if (project != null && project.isAccessible()) {
            Map<MapKey, IObjectLocator> map = this.objectLocatorMap;
            synchronized (map) {
                for (MapKey mapKey : this.objectLocatorMap.keySet()) {
                    if (!project.equals((Object)mapKey.project)) continue;
                    return mapKey.earProject;
                }
            }
        }
        return null;
    }

    @Override
    public List<? extends IPageDefinition> getPageDefinitions(IProject earProject, IContainer container) {
        IObjectLocator objectLocator = this.getObjectLocator(earProject, (IResource)container);
        return objectLocator != null ? objectLocator.getPageDefinitions(earProject, container) : Collections.emptyList();
    }

    @Override
    public IPageDefinition getPageDefinition(IProject earProject, IFile pageDefinitionFile) {
        IObjectLocator objectLocator = this.getObjectLocator(earProject, (IResource)pageDefinitionFile);
        return objectLocator != null ? objectLocator.getPageDefinition(earProject, pageDefinitionFile) : null;
    }

    @Override
    public IPageDefinition getPageDefinitionForWebPage(IProject earProject, IFile webPageFile) {
        IObjectLocator objectLocator = this.getObjectLocator(earProject, (IResource)webPageFile);
        return objectLocator != null ? objectLocator.getPageDefinitionForWebPage(earProject, webPageFile) : null;
    }

    @Override
    public List<? extends IPageDefinition> getPageDefinitions(IProject earProject, ITaskFlowContext.ITaskFlowProxy taskFlow) {
        IObjectLocator objectLocator;
        IFile file;
        if (taskFlow != null && (file = taskFlow.getTaskFlowFile()) != null && (objectLocator = this.getObjectLocator(earProject, (IResource)file)) != null) {
            return objectLocator.getPageDefinitions(earProject, taskFlow);
        }
        return null;
    }

    @Override
    public IPageDefinition getPageDefinitionForTaskFlowActivity(IProject earProject, ITaskFlowContext.ITaskFlowProxy taskFlow, Object activity) {
        IObjectLocator objectLocator;
        IFile file;
        if (taskFlow != null && (file = taskFlow.getTaskFlowFile()) != null && (objectLocator = this.getObjectLocator(earProject, (IResource)file)) != null) {
            return objectLocator.getPageDefinitionForTaskFlowActivity(earProject, taskFlow, activity);
        }
        return null;
    }

    @Override
    public IApplication getApplication(IProject earProject, IFile applicationFile) {
        IObjectLocator objectLocator = this.getObjectLocator(earProject, (IResource)applicationFile);
        return objectLocator != null ? objectLocator.getApplication(earProject, applicationFile) : null;
    }

    @Override
    public List<? extends IApplication> getApplications(IProject earProject, IContainer container) {
        IObjectLocator objectLocator = this.getObjectLocator(earProject, (IResource)container);
        return objectLocator != null ? objectLocator.getApplications(earProject, container) : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addListener(IOEPEContext.IContextListener listener) {
        this.listeners.add(listener);
        Map<MapKey, IObjectLocator> map = this.objectLocatorMap;
        synchronized (map) {
            for (IObjectLocator objectLocator : this.objectLocatorMap.values()) {
                objectLocator.addListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeListener(IOEPEContext.IContextListener listener) {
        this.listeners.remove(listener);
        Map<MapKey, IObjectLocator> map = this.objectLocatorMap;
        synchronized (map) {
            for (IObjectLocator objectLocator : this.objectLocatorMap.values()) {
                objectLocator.removeListener(listener);
            }
        }
    }

    @Override
    public boolean isKnown(IObject object) {
        IObjectLocator objectLocator = this.getObjectLocator(object);
        return objectLocator != null;
    }

    @Override
    public IFile getAccessibleFile(IObject object) throws IllegalArgumentException {
        IObjectLocator objectLocator = this.getObjectLocator(object);
        if (objectLocator != null) {
            try {
                IFile file = objectLocator.getAccessibleFile(object);
                if (file != null) {
                    return file;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public List<? extends IFileMarker> getAccessibleDeclarations(IObject object) throws IllegalArgumentException {
        IObjectLocator objectLocator = this.getObjectLocator(object);
        if (objectLocator != null) {
            try {
                List<? extends IFileMarker> declarations = objectLocator.getAccessibleDeclarations(object);
                if (!declarations.isEmpty()) {
                    return declarations;
                }
            }
            catch (Exception exception) {}
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<? extends IPageDefinition> getPageDefinitions(IApplication application) {
        IObjectLocator objectLocator = this.getObjectLocator(application);
        if (objectLocator != null) {
            try {
                Collection<? extends IPageDefinition> pageDefinitions = objectLocator.getPageDefinitions(application);
                if (!pageDefinitions.isEmpty()) {
                    return pageDefinitions;
                }
            }
            catch (Exception exception) {}
        }
        return Collections.emptySet();
    }

    @Override
    public Map<IApplication, List<IPageDefinition.IBoundSource>> getApplications(IPageDefinition pageDefinition) {
        IObjectLocator objectLocator = this.getObjectLocator(pageDefinition);
        if (objectLocator != null) {
            try {
                Map<IApplication, List<IPageDefinition.IBoundSource>> applications = objectLocator.getApplications(pageDefinition);
                if (!applications.isEmpty()) {
                    return applications;
                }
            }
            catch (Exception exception) {}
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean hasUpdateableStructure(IStructure.IStructureSource source) throws IllegalArgumentException {
        IObjectLocator objectLocator;
        IResource resource = DTRTObjectUtil.getResource(source);
        if (resource != null && (objectLocator = this.getObjectLocator(resource)) != null) {
            return objectLocator.hasUpdateableStructure(source);
        }
        return false;
    }

    @Override
    public boolean hasUpdateableStructure(IProject earProject, IStructure.IStructureSource source) {
        IObjectLocator objectLocator;
        IResource resource = DTRTObjectUtil.getResource(source);
        if (resource != null && (objectLocator = this.getObjectLocator(earProject, resource)) != null) {
            return objectLocator.hasUpdateableStructure(earProject, source);
        }
        return false;
    }

    @Override
    public IStatus validate(IObject object, IProgressMonitor monitor) {
        IObjectLocator objectLocator = this.getObjectLocator(object);
        return objectLocator != null ? objectLocator.validate(object, monitor) : null;
    }

    private IObjectLocator getObjectLocator(IProject assemblyProject, IResource projectResource) {
        IProject project;
        if (assemblyProject != null && projectResource != null && (project = projectResource.getProject()) != null) {
            MapKey mapKey = new MapKey(assemblyProject, project);
            return this.getObjectLocator(mapKey);
        }
        return null;
    }

    private IObjectLocator getObjectLocator(IResource projectResource) {
        IProject project;
        if (projectResource != null && (project = projectResource.getProject()) != null) {
            MapKey mapKey = new MapKey(project);
            return this.getObjectLocator(mapKey);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectLocator getObjectLocator(MapKey mapKey) {
        Map<MapKey, IObjectLocator> map = this.objectLocatorMap;
        synchronized (map) {
            IObjectLocatorContext locatorContext;
            IObjectLocator objectLocator = this.objectLocatorMap.get(mapKey);
            if (objectLocator == null && (locatorContext = DTRTUtil.createContext((IResource)mapKey.getProject(), IObjectLocatorContext.class)) != null) {
                try {
                    locatorContext = locatorContext.initialize(null);
                    for (IOEPEContext.IContextListener listener : this.listeners) {
                        locatorContext.addListener(listener);
                    }
                    objectLocator = new SynchronizedObjectLocator(locatorContext);
                    this.objectLocatorMap.put(mapKey, objectLocator);
                }
                catch (Exception exception) {}
            }
            return objectLocator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectLocator getObjectLocator(IObject object) {
        if (object != null) {
            Map<MapKey, IObjectLocator> map = this.objectLocatorMap;
            synchronized (map) {
                for (IObjectLocator objectLocator : this.objectLocatorMap.values()) {
                    if (!objectLocator.isKnown(object)) continue;
                    return objectLocator;
                }
            }
        }
        return null;
    }

    private static final class MapKey {
        private final IProject earProject;
        private final IProject project;

        private MapKey(IProject earProject, IProject webProject) {
            this.earProject = earProject;
            this.project = webProject;
        }

        private MapKey(IProject modelProject) {
            this.earProject = null;
            this.project = modelProject;
        }

        public IProject getProject() {
            return this.project;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.earProject == null ? 0 : this.earProject.hashCode());
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MapKey other = (MapKey)obj;
            return DTRTUtil.equals(this.earProject, other.earProject) && DTRTUtil.equals(this.project, other.project);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MapKey [").append("earProject=").append(this.earProject).append(", project=").append(this.project);
            return builder.append(']').toString();
        }
    }
}

