/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.jdt;

import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;

public final class TypeInfo {
    private String className;
    private String sourceName;

    public static String toClassName(String sourceName) {
        if (!DTRTUtil.isEmpty(sourceName)) {
            int index1 = sourceName.indexOf(60);
            int index2 = sourceName.indexOf(91);
            if (index1 > 0) {
                return index2 > 0 ? sourceName.substring(0, Math.min(index1, index2)) : sourceName.substring(0, index1);
            }
            if (index2 > 0) {
                return sourceName.substring(0, index2);
            }
        }
        return sourceName;
    }

    public static int sourceNameNumberOfArrayDimensions(String sourceName) {
        char[] chars;
        if (sourceName != null && (chars = (sourceName = sourceName.replace(" ", "")).toCharArray())[chars.length - 1] == ']') {
            int counter = 0;
            int i = chars.length - 1;
            while (i >= 1) {
                if (chars[i - 1] != '[' || chars[i] != ']') break;
                ++counter;
                i -= 2;
            }
            return counter;
        }
        return 0;
    }

    TypeInfo() {
    }

    TypeInfo setClassName(String className) {
        this.className = className;
        return this;
    }

    public String getClassName() {
        if (this.className != null) {
            return this.className;
        }
        return TypeInfo.toClassName(this.sourceName);
    }

    TypeInfo setSourceName(String sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    public String getSourceName() {
        if (this.sourceName != null) {
            return this.sourceName;
        }
        return this.className;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.sourceName == null ? 0 : this.sourceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TypeInfo)) {
            return false;
        }
        TypeInfo other = (TypeInfo)obj;
        return DTRTUtil.equals(this.className, other.className) && DTRTUtil.equals(this.sourceName, other.sourceName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TypeInfo [className=");
        builder.append(this.getClassName());
        builder.append(", sourceName=");
        builder.append(this.getSourceName());
        builder.append("]");
        return builder.toString();
    }
}

