/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.jdt;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.jdt.BasicMemberFilter;
import oracle.eclipse.tools.adf.dtrt.jdt.BasicTypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.IMemberFilter;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.JDTUtil;
import oracle.eclipse.tools.adf.dtrt.jdt.TypeInfo;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public final class MemberFilterUtil {
    public static final IMemberFilter INCLUDE_ALL = new BasicMemberFilter("IncludeAll"){

        @Override
        public boolean include(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) {
            return true;
        }
    };
    public static final IMemberFilter EXCLUDE_NOT_CONSTRUCTORS = new BasicMemberFilter("ExcludeNotConstructors"){

        @Override
        public boolean exclude(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            return !(member instanceof IMethod) || !((IMethod)member).isConstructor();
        }
    };
    public static final IMemberFilter EXCLUDE_CONSTRUCTORS = new BasicMemberFilter("ExcludeConstructors"){

        @Override
        public boolean exclude(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            return member instanceof IMethod && ((IMethod)member).isConstructor();
        }
    };
    public static final IMemberFilter EXCLUDE_OVERRIDEN_METHODS = new BasicMemberFilter("ExcludeOverridenMethods"){

        @Override
        public boolean exclude(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            if (mainType != null && member instanceof IMethod) {
                IMethod method = (IMethod)member;
                for (IMember iMember : includedMembers) {
                    if (!(iMember instanceof IMethod) || !((BasicTypeHelper)typeHelper).isOverriding(mainType, (IMethod)iMember, method)) continue;
                    return true;
                }
            }
            return false;
        }
    };
    public static final IMemberFilter EXCLUDE_SAME_NAME_FIELDS = new BasicMemberFilter("ExcludeSameNameFields"){

        @Override
        public boolean exclude(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            if (member instanceof IField) {
                String name = member.getElementName();
                for (IMember iMember : includedMembers) {
                    if (!(iMember instanceof IField) || !name.equals(iMember.getElementName())) continue;
                    return true;
                }
            }
            return false;
        }
    };
    public static final FlagFilter PUBLIC = new FlagFilter("Public", 1);
    public static final FlagFilter PUBLIC_PROTECTED = new FlagFilter("PublicProtected", 5);
    public static final IMemberFilter PUBLIC_PROTECTED_DEFAULT = new CompoundFilter("PublicProtectedDefault", PUBLIC_PROTECTED, new BasicMemberFilter(){

        @Override
        public boolean include(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            return Flags.isPackageDefault((int)member.getFlags());
        }
    });
    public static final IMemberFilter EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS = new TargetedFilter(false, new FlagFilter(true, 2), EXCLUDE_CONSTRUCTORS, new BasicMemberFilter(){

        @Override
        public boolean exclude(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            return mainType != null && member.getDeclaringType().isInterface() && !mainType.isInterface() && !Flags.isAbstract((int)mainType.getFlags());
        }
    }, EXCLUDE_SAME_NAME_FIELDS, EXCLUDE_OVERRIDEN_METHODS);
    public static final IMemberFilter EXCLUDE_OBJECT_MEMBERS = new Invert(new MemberFinder().findByDeclaringType("java.lang.Object"));
    public static final IMemberFilter EXCLUDE_NOT_PUBLIC = new ExcludeNotInserted((IMemberFilter)PUBLIC);

    private MemberFilterUtil() {
    }

    public static class CompoundFilter
    extends BasicMemberFilter {
        private IMemberFilter[] filters;

        public CompoundFilter(IMemberFilter ... filters) {
            this((String)null, filters);
        }

        public CompoundFilter(String name, IMemberFilter ... filters) {
            super(name);
            this.filters = filters == null || filters.length == 0 ? new IMemberFilter[0] : filters;
        }

        protected IMemberFilter[] getFilters() {
            return this.filters;
        }

        @Override
        public boolean include(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            IMemberFilter[] iMemberFilterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberFilter filter = iMemberFilterArray[n2];
                if (filter.include(includedMembers, typeHelper, mainType, member)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public boolean exclude(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            IMemberFilter[] iMemberFilterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberFilter filter = iMemberFilterArray[n2];
                if (filter.exclude(includedMembers, typeHelper, mainType, member)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public boolean stop(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            IMemberFilter[] iMemberFilterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberFilter filter = iMemberFilterArray[n2];
                if (filter.stop(includedMembers, typeHelper, mainType, member)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static class ExcludeNotInserted
    extends CompoundFilter {
        private IMemberFilter filter;

        public ExcludeNotInserted(IMemberFilter filter) {
            super(new IMemberFilter[0]);
            this.filter = filter;
        }

        public ExcludeNotInserted(IMemberFilter ... filters) {
            super(filters);
        }

        @Override
        public boolean include(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            return false;
        }

        @Override
        public boolean exclude(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            return this.filter != null ? !this.filter.include(includedMembers, typeHelper, mainType, member) : !super.include(includedMembers, typeHelper, mainType, member);
        }
    }

    public static class FlagFilter
    extends BasicMemberFilter {
        public static final int ACC_ANY = -1;
        private int flags = -1;
        private boolean isExclude;

        public FlagFilter(int flags) {
            this(null, false, flags);
        }

        public FlagFilter(boolean isExclude, int flags) {
            this(null, isExclude, flags);
        }

        public FlagFilter(String filterName, int flags) {
            this(null, false, flags);
        }

        public FlagFilter(String filterName, boolean isExclude, int flags) {
            super(filterName);
            this.flags = flags;
            this.isExclude = isExclude;
        }

        public int getFlags() {
            return this.flags;
        }

        public boolean isExclude() {
            return this.isExclude;
        }

        @Override
        public boolean include(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            return !this.isExclude() && this.isFlagApplicable(member);
        }

        @Override
        public boolean exclude(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            return this.isExclude() && this.isFlagApplicable(member);
        }

        private boolean isFlagApplicable(IMember member) throws CoreException {
            IType declaringType;
            int flags = this.getFlags();
            return flags == -1 || (member.getFlags() & flags) != 0 || ((flags & 1) != 0 || (flags & 0x400) != 0) && (declaringType = member.getDeclaringType()) != null && declaringType.isInterface();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.flags;
            result = 31 * result + (this.isExclude ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof FlagFilter)) {
                return false;
            }
            FlagFilter other = (FlagFilter)obj;
            return this.flags == other.flags && this.isExclude == other.isExclude;
        }
    }

    public static class Invert
    extends CompoundFilter {
        private IMemberFilter filter;

        public Invert(IMemberFilter filter) {
            super(new IMemberFilter[0]);
            this.filter = filter;
        }

        public Invert(IMemberFilter ... filters) {
            super(filters);
        }

        @Override
        public boolean include(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            return this.filter != null ? this.filter.exclude(includedMembers, typeHelper, mainType, member) : super.exclude(includedMembers, typeHelper, mainType, member);
        }

        @Override
        public boolean exclude(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            return this.filter != null ? this.filter.include(includedMembers, typeHelper, mainType, member) : super.include(includedMembers, typeHelper, mainType, member);
        }
    }

    public static class MaximumNumberOfIncludedMembers
    extends BasicMemberFilter {
        private int number;

        public MaximumNumberOfIncludedMembers(int number) {
            super("MaximumNumberOfIncludedMembers:" + number);
            this.number = number;
        }

        @Override
        public boolean stop(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            return includedMembers.size() > this.number;
        }
    }

    public static class MemberFinder
    extends BasicMemberFilter {
        private String memberName;
        private String prefix;
        private boolean byMethodSignature;
        private String[] parameterTypes;
        private boolean matchErasedParameterTypes;
        private String declaringTypeName;
        private boolean stopAfterFinding;
        private boolean found;

        private void init() {
            this.memberName = null;
            this.prefix = null;
            this.byMethodSignature = false;
            this.parameterTypes = null;
            this.matchErasedParameterTypes = false;
            this.declaringTypeName = null;
        }

        public MemberFinder() {
        }

        public MemberFinder(boolean stopAfterFinding) {
            this.stopAfterFinding = stopAfterFinding;
        }

        public IMemberFilter findByName(String memberName) {
            this.init();
            this.memberName = memberName;
            return this;
        }

        public IMemberFilter findByPrefix(String prefix) {
            this.init();
            this.prefix = prefix;
            return this;
        }

        public IMemberFilter findMethod(String methodName, String ... parameterTypes) {
            return this.findMethod(false, methodName, parameterTypes);
        }

        public IMemberFilter findMethod(boolean matchErasedParameterTypes, String methodName, String ... parameterTypes) {
            this.init();
            this.byMethodSignature = true;
            this.matchErasedParameterTypes = matchErasedParameterTypes;
            this.memberName = methodName;
            this.parameterTypes = parameterTypes;
            return this;
        }

        public IMemberFilter findMethodByPrefix(String methodNamePrefix, String ... parameterTypes) {
            return this.findMethodByPrefix(false, methodNamePrefix, parameterTypes);
        }

        public IMemberFilter findMethodByPrefix(boolean matchErasedParameterTypes, String methodNamePrefix, String ... parameterTypes) {
            this.init();
            this.byMethodSignature = true;
            this.matchErasedParameterTypes = matchErasedParameterTypes;
            this.prefix = methodNamePrefix;
            this.parameterTypes = parameterTypes;
            return this;
        }

        public IMemberFilter findByDeclaringType(String declaringTypeName) {
            this.init();
            this.declaringTypeName = declaringTypeName;
            return this;
        }

        @Override
        public boolean include(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            this.found = this.doInclude(includedMembers, typeHelper, mainType, member);
            return this.found;
        }

        private boolean doInclude(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            BasicTypeHelper basicTypeHelper = (BasicTypeHelper)typeHelper;
            if (this.byMethodSignature) {
                if (member instanceof IMethod) {
                    boolean nameMatches;
                    IMethod method = (IMethod)member;
                    boolean bl = this.prefix != null ? method.getElementName().startsWith(this.prefix) : (nameMatches = this.memberName == null && method.isConstructor() || method.getElementName().equals(this.memberName));
                    if (nameMatches) {
                        String[] parameterSignatures = ((IMethod)member).getParameterTypes();
                        if (this.parameterTypes == null || this.parameterTypes.length == 0) {
                            return parameterSignatures.length == 0;
                        }
                        if (this.parameterTypes.length == parameterSignatures.length) {
                            Map<String, String> erasedTypeParameters;
                            String[] array2;
                            String[] array1 = basicTypeHelper.toMethodParameterCompareArray(this.parameterTypes, false);
                            if (basicTypeHelper.areSimilarMethodParameterCompareArrays(array1, array2 = basicTypeHelper.toMethodParameterCompareArray(parameterSignatures, true))) {
                                return true;
                            }
                            if (this.matchErasedParameterTypes && !(erasedTypeParameters = typeHelper.getErasedTypeParameters(method)).isEmpty()) {
                                boolean found = false;
                                ILocalVariable[] parameters = method.getParameters();
                                int i = 0;
                                while (i < parameters.length) {
                                    ILocalVariable parameter;
                                    TypeInfo parameterTypeInfo;
                                    String finderParameterClassName = basicTypeHelper.toResolvedClassName(basicTypeHelper.toResolvedName((IJavaElement)method, TypeInfo.toClassName(this.parameterTypes[i])));
                                    boolean bl2 = found = (finderParameterClassName.equals((parameterTypeInfo = typeHelper.getTypeInfo(parameter = parameters[i])).getClassName()) || finderParameterClassName.equals(erasedTypeParameters.get(parameterTypeInfo.getClassName()))) && TypeInfo.sourceNameNumberOfArrayDimensions(parameterTypeInfo.getSourceName()) == TypeInfo.sourceNameNumberOfArrayDimensions(this.parameterTypes[i]);
                                    if (!found) break;
                                    ++i;
                                }
                                return found;
                            }
                        }
                    }
                }
                return false;
            }
            if (this.declaringTypeName != null) {
                IType declaringType = member.getDeclaringType();
                return declaringType != null && basicTypeHelper.matches(declaringType, this.declaringTypeName);
            }
            if (member instanceof IType) {
                IType type = (IType)member;
                return this.prefix != null ? type.getFullyQualifiedName().startsWith(this.prefix) || type.getFullyQualifiedName().replace('$', '.').startsWith(this.prefix) || type.getElementName().startsWith(this.prefix) : basicTypeHelper.matches(type, this.memberName);
            }
            if (member instanceof IField || member instanceof IMethod) {
                return this.prefix != null ? member.getElementName().startsWith(this.prefix) : member.getElementName().equals(this.memberName);
            }
            return false;
        }

        @Override
        public boolean stop(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) {
            return this.stopAfterFinding && this.found;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.memberName == null ? 0 : this.memberName.hashCode());
            result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
            result = 31 * result + (this.byMethodSignature ? 1231 : 1237);
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            result = 31 * result + (this.stopAfterFinding ? 1231 : 1237);
            result = 31 * result + (this.matchErasedParameterTypes ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof MemberFinder)) {
                return false;
            }
            MemberFinder other = (MemberFinder)obj;
            return this.stopAfterFinding == other.stopAfterFinding && this.byMethodSignature == other.byMethodSignature && this.matchErasedParameterTypes == other.matchErasedParameterTypes && DTRTUtil.equals(this.memberName, other.memberName) && DTRTUtil.equals(this.prefix, other.prefix) && DTRTUtil.equals(this.parameterTypes, other.parameterTypes);
        }
    }

    public static class TargetedFilter
    extends CompoundFilter {
        private boolean applicableToMainTypeMembers;

        public TargetedFilter(boolean applicableToMainTypeMembers, IMemberFilter ... filters) {
            super(filters);
            this.applicableToMainTypeMembers = applicableToMainTypeMembers;
        }

        public boolean isApplicableToMainTypeMembers() {
            return this.applicableToMainTypeMembers;
        }

        @Override
        public boolean include(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            if (this.getFilters().length > 0 && JDTUtil.isMemberOf(mainType, member) == this.isApplicableToMainTypeMembers()) {
                return super.include(includedMembers, typeHelper, mainType, member);
            }
            return false;
        }

        @Override
        public boolean exclude(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            if (this.getFilters().length > 0 && JDTUtil.isMemberOf(mainType, member) == this.isApplicableToMainTypeMembers()) {
                return super.exclude(includedMembers, typeHelper, mainType, member);
            }
            return false;
        }

        @Override
        public boolean stop(Collection<? extends IMember> includedMembers, ITypeHelper typeHelper, IType mainType, IMember member) throws Exception {
            if (this.getFilters().length > 0 && JDTUtil.isMemberOf(mainType, member) == this.isApplicableToMainTypeMembers()) {
                return super.stop(includedMembers, typeHelper, mainType, member);
            }
            return false;
        }
    }
}

