/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.jdt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.internal.DTRTBundle;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.JDTUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEdit;

public class JavaCodeManipulationHelper {
    private CodeFormatter formatter;
    private Map<IFile, ICompilationUnit> workingCopyMap;
    private Map<ICompilationUnit, List<IMember>> membersToFormat;
    private ITypeHelper typeHelper;

    public void dispose() {
        this.formatter = null;
        if (this.membersToFormat != null) {
            this.membersToFormat.clear();
            this.membersToFormat = null;
        }
        if (this.workingCopyMap != null) {
            for (ICompilationUnit compilationUnit : this.workingCopyMap.values()) {
                try {
                    compilationUnit.discardWorkingCopy();
                }
                catch (Exception exception) {}
            }
            this.workingCopyMap.clear();
            this.workingCopyMap = null;
        }
        if (this.typeHelper != null) {
            this.typeHelper.reset();
            this.typeHelper = null;
        }
    }

    public boolean isValidClass(IFile javaFile, String className, IProgressMonitor monitor) {
        try {
            ICompilationUnit compilationUnit = this.getCompilationUnit(javaFile, monitor);
            return this.findType(compilationUnit, className, false) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ICompilationUnit createClass(final IFile javaFile, String superClass, IProgressMonitor monitor) throws CoreException {
        if (javaFile.exists()) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt", "Cannot create class.   Already exsists: " + javaFile.getName()));
        }
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
        Pair<String, String> classInfo = this.getInfo(javaFile);
        Pair<String, String> superClassInfo = this.getInfo(superClass);
        String imports = ((String)classInfo.getFirst()).equals(superClassInfo.getFirst()) ? "" : "import " + (String)superClassInfo.getFirst() + ";\n";
        final String contents = String.format("package %s;\n%s\npublic class %s extends %s {\n\n\tpublic %s() {\n\t\tsuper();\n\t}\n\n}", classInfo.getFirst(), imports, classInfo.getSecond(), superClassInfo.getSecond(), classInfo.getSecond());
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ByteArrayInputStream source = new ByteArrayInputStream(contents.getBytes());
                javaFile.create((InputStream)source, true, monitor);
            }
        };
        runnable.run(monitor);
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
        return this.getCompilationUnit(javaFile, monitor);
    }

    private Pair<String, String> getInfo(IFile javaFile) {
        IPath path = javaFile.getProjectRelativePath().removeFirstSegments(1);
        IPath packagePath = path.removeLastSegments(1);
        String packagePart = packagePath.toString().replace('/', '.').replace('\\', '.');
        String classPart = new Path(path.lastSegment()).removeFileExtension().toString();
        return new Pair((Object)packagePart, (Object)classPart);
    }

    private Pair<String, String> getInfo(String superClass) {
        int lastDot = superClass.lastIndexOf(46);
        String pkg = "";
        String className = null;
        if (lastDot > 0) {
            pkg = superClass.substring(0, lastDot);
            className = superClass.substring(lastDot + 1);
        } else {
            className = superClass;
        }
        return new Pair((Object)pkg, (Object)className);
    }

    public boolean createField(IFile javaFile, String className, String fieldCode, IProgressMonitor monitor) throws CoreException {
        IField field;
        block2: {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
            field = null;
            ICompilationUnit compilationUnit = this.getCompilationUnit(javaFile, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
            IType type = this.findType(compilationUnit, className, true);
            try {
                field = type.createField(fieldCode, null, false, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
                this.handleCreatedMember(compilationUnit, (IMember)field);
            }
            catch (JavaModelException e) {
                if (e.getStatus().getCode() == 977) break block2;
                throw e;
            }
        }
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
        return field != null;
    }

    public boolean deleteField(IFile javaFile, String className, String fieldName, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
        ICompilationUnit compilationUnit = this.getCompilationUnit(javaFile, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        IType type = this.findType(compilationUnit, className, true);
        IField field = type.getField(fieldName);
        if (field != null) {
            try {
                field.delete(true, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
                this.handleDeletedMember(compilationUnit, (IMember)field);
            }
            catch (JavaModelException e) {
                if (!e.isDoesNotExist()) {
                    throw e;
                }
                field = null;
            }
        }
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
        return field != null;
    }

    public boolean createMethod(IFile javaFile, String className, String methodCode, IProgressMonitor monitor) throws CoreException {
        IMethod method;
        block2: {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
            method = null;
            ICompilationUnit compilationUnit = this.getCompilationUnit(javaFile, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
            IType type = this.findType(compilationUnit, className, true);
            try {
                method = type.createMethod(methodCode, null, false, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
                this.handleCreatedMember(compilationUnit, (IMember)method);
            }
            catch (JavaModelException e) {
                if (e.getStatus().getCode() == 977) break block2;
                throw e;
            }
        }
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
        return method != null;
    }

    public boolean deleteMethod(IFile javaFile, String className, String methodName, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
        ICompilationUnit compilationUnit = this.getCompilationUnit(javaFile, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        IType type = this.findType(compilationUnit, className, true);
        IMethod method = type.getMethod(methodName, new String[0]);
        if (method != null) {
            try {
                method.delete(true, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
                this.handleDeletedMember(compilationUnit, (IMember)method);
            }
            catch (JavaModelException e) {
                if (!e.isDoesNotExist()) {
                    throw e;
                }
                method = null;
            }
        }
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
        return method != null;
    }

    public boolean createImport(IFile javaFile, String className, String importClassName, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
        ICompilationUnit compilationUnit = this.getCompilationUnit(javaFile, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        this.findType(compilationUnit, className, true);
        IImportDeclaration importDeclaration = compilationUnit.getImport(importClassName);
        if (!importDeclaration.exists()) {
            compilationUnit.createImport(importClassName, null, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
            return true;
        }
        return false;
    }

    public boolean deleteImport(IFile javaFile, String className, String importClassName, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
        ICompilationUnit compilationUnit = this.getCompilationUnit(javaFile, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        this.findType(compilationUnit, className, true);
        IImportDeclaration importDeclaration = compilationUnit.getImport(importClassName);
        if (this.canDelete(compilationUnit, importDeclaration)) {
            importDeclaration.delete(true, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
            return true;
        }
        return false;
    }

    public void save(IProgressMonitor monitor) throws CoreException {
        if (this.workingCopyMap != null && !this.workingCopyMap.isEmpty()) {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)(this.workingCopyMap.size() * 4));
            IPath compilationUnitPath = null;
            try {
                for (ICompilationUnit compilationUnit : this.workingCopyMap.values()) {
                    assert (compilationUnit.isWorkingCopy());
                    compilationUnitPath = compilationUnit.getPath();
                    if (this.membersToFormat != null && !this.membersToFormat.isEmpty()) {
                        try {
                            this.formatMembers(compilationUnit, (Collection<IMember>)this.membersToFormat.get(compilationUnit), ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                        }
                        catch (Exception e) {
                            DTRTBundle.log(e);
                        }
                    }
                    compilationUnit.commitWorkingCopy(false, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
                }
            }
            catch (Exception e) {
                if (compilationUnitPath != null) {
                    throw new CoreException(DTRTUtil.createErrorStatus(NLS.bind((String)Messages.errorSavingJava, (Object)compilationUnitPath.toString()), e));
                }
                if (e instanceof CoreException) {
                    throw (CoreException)((Object)e);
                }
                throw new CoreException(DTRTUtil.createErrorStatus(e));
            }
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private ITypeHelper getTypeHelper() {
        return this.typeHelper == null ? (this.typeHelper = JDTUtil.createTypeHelper()) : this.typeHelper;
    }

    public ICompilationUnit createCompilationUnit(IProject project, IFile javaFile, IProgressMonitor monitor, String superClass, String ... interfaces) throws CoreException {
        if (javaFile.exists()) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt", "Java file to be created already exists: " + javaFile.toString()));
        }
        return this.getCompilationUnit(javaFile, monitor);
    }

    private ICompilationUnit getCompilationUnit(IFile javaFile, IProgressMonitor monitor) throws CoreException {
        ICompilationUnit compilationUnit;
        if (this.workingCopyMap == null) {
            this.workingCopyMap = new HashMap<IFile, ICompilationUnit>();
        }
        if ((compilationUnit = this.workingCopyMap.get(javaFile)) == null && (compilationUnit = this.getTypeHelper().getCompilationUnit(javaFile, true)) != null) {
            assert (compilationUnit.isWorkingCopy()) : javaFile;
            this.workingCopyMap.put(javaFile, compilationUnit);
        }
        return compilationUnit;
    }

    private IType findType(ICompilationUnit compilationUnit, String className, boolean throwException) throws CoreException {
        IType type = this.getTypeHelper().findType(compilationUnit, className);
        if (type == null && throwException) {
            throw new CoreException(DTRTUtil.createErrorStatus(Messages.errorNoType));
        }
        return type;
    }

    private void handleCreatedMember(ICompilationUnit compilationUnit, IMember member) {
        List<IMember> members;
        if (this.membersToFormat == null) {
            this.membersToFormat = new HashMap<ICompilationUnit, List<IMember>>();
        }
        if ((members = this.membersToFormat.get(compilationUnit)) == null) {
            members = new ArrayList<IMember>();
            this.membersToFormat.put(compilationUnit, members);
        }
        members.add(member);
    }

    private void handleDeletedMember(ICompilationUnit compilationUnit, IMember member) {
        List<IMember> members;
        if (this.membersToFormat != null && (members = this.membersToFormat.get(compilationUnit)) != null) {
            members.remove(member);
        }
    }

    private void formatMembers(ICompilationUnit compilationUnit, Collection<IMember> members, IProgressMonitor monitor) throws CoreException {
        if (members != null && !members.isEmpty()) {
            if (this.formatter == null) {
                this.formatter = ToolFactory.createCodeFormatter(null, (int)ToolFactory.M_FORMAT_EXISTING);
            }
            int index = 0;
            IRegion[] regions = new IRegion[members.size()];
            for (IMember member : members) {
                assert (compilationUnit == member.getCompilationUnit());
                ISourceRange sourceRange = member.getSourceRange();
                Region region = new Region(sourceRange.getOffset(), sourceRange.getLength());
                regions[index++] = region;
            }
            TextEdit textEdit = this.formatter.format(8, compilationUnit.getSource(), regions, 0, null);
            if (textEdit != null) {
                compilationUnit.applyTextEdit(textEdit, monitor);
            }
        }
    }

    private boolean canDelete(ICompilationUnit compilationUnit, IImportDeclaration importDeclaration) throws CoreException {
        int index;
        String className;
        String source;
        if (importDeclaration != null && importDeclaration.exists() && !importDeclaration.isOnDemand() && !this.hasMoreThanOneOccurrence(source = compilationUnit.getSource(), className = importDeclaration.getElementName()) && (index = className.lastIndexOf(46)) > 0) {
            String simpleClassName = className.substring(index + 1);
            return !this.hasMoreThanOneOccurrence(source, simpleClassName);
        }
        return false;
    }

    private boolean hasMoreThanOneOccurrence(String string, String toFind) {
        int index;
        if (!DTRTUtil.isEmpty(string) && !DTRTUtil.isEmpty(toFind) && (index = string.indexOf(toFind)) >= 0) {
            return (index = string.indexOf(toFind, index + toFind.length())) > 0;
        }
        return false;
    }

    private static class Messages
    extends NLS {
        public static String errorNoType;
        public static String errorSavingJava;

        static {
            NLS.initializeMessages((String)JavaCodeManipulationHelper.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

