/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.jdt;

import oracle.eclipse.tools.adf.dtrt.jdt.BasicTypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.IMemberFilter;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelperClient;
import oracle.eclipse.tools.adf.dtrt.jdt.ManagedTypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.MemberFilterUtil;
import oracle.eclipse.tools.adf.dtrt.jdt.SimpleCacheTypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.TypeInfo;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class JDTUtil {
    private static ITypeHelper notCachingTypeHelper;
    private static ITypeHelper managedTypeHelper;

    private JDTUtil() {
    }

    public static ITypeHelper createTypeHelper() {
        return new SimpleCacheTypeHelper();
    }

    public static ITypeHelper createTypeHelper(ITypeHelperClient client) {
        return new SimpleCacheTypeHelper(client);
    }

    public static boolean dispose(ITypeHelper typeHelper) {
        if (typeHelper instanceof SimpleCacheTypeHelper) {
            ((SimpleCacheTypeHelper)typeHelper).dispose();
            return true;
        }
        return false;
    }

    public static ITypeHelper getNoCachingTypeHelper() {
        return notCachingTypeHelper == null ? (notCachingTypeHelper = new BasicTypeHelper()) : notCachingTypeHelper;
    }

    public static ITypeHelper getManagedTypeHelper() {
        return managedTypeHelper == null ? (managedTypeHelper = new ManagedTypeHelper()) : managedTypeHelper;
    }

    public static boolean isMemberOf(IType type, IMember member) {
        return type != null && member != null && JDTUtil.equals(type, member.getDeclaringType());
    }

    public static IMemberValuePair findMemberValuePair(IAnnotation annotation, String memberName) throws CoreException {
        if (annotation != null && !DTRTUtil.isEmpty(memberName)) {
            IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair memberValuePair = iMemberValuePairArray[n2];
                if (memberName.equals(memberValuePair.getMemberName())) {
                    return memberValuePair;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IMethod findAccessibleMethod(ITypeHelper typeHelper, IType type, boolean visitSuperTypes, int matchingFlags, boolean matchErasedParameterTypes, String methodName, String ... parameterTypes) throws CoreException {
        if (typeHelper != null && type != null) {
            IMemberFilter[] filters = new IMemberFilter[]{new MemberFilterUtil.ExcludeNotInserted((IMemberFilter)new MemberFilterUtil.FlagFilter(matchingFlags)), visitSuperTypes ? MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS : null, new MemberFilterUtil.MemberFinder(true).findMethod(matchErasedParameterTypes, methodName, parameterTypes)};
            return DTRTUtil.getFirstElement(typeHelper.getMethods(type, visitSuperTypes, filters));
        }
        return null;
    }

    public static String getMethodSignature(ITypeHelper typeHelper, IMethod method, boolean includeTypeName) throws CoreException {
        if (typeHelper != null && method != null) {
            ITypeParameter[] typeParameters;
            StringBuilder sb = new StringBuilder();
            if (includeTypeName) {
                sb.append(typeHelper.getTypeInfo(method.getDeclaringType()).getClassName()).append('.');
            }
            if ((typeParameters = method.getTypeParameters()).length > 0) {
                sb.append('<');
                int i = 0;
                int max = typeParameters.length - 1;
                while (i <= max) {
                    sb.append(typeParameters[i].getElementName());
                    if (i < max) {
                        sb.append(", ");
                    }
                    ++i;
                }
                sb.append('>');
            }
            sb.append(method.getElementName());
            sb.append('(');
            ILocalVariable[] parameters = method.getParameters();
            int i = 0;
            int max = parameters.length - 1;
            while (i <= max) {
                TypeInfo parameterTypeInfo = typeHelper.getTypeInfo(parameters[i]);
                sb.append(parameterTypeInfo.getSourceName());
                if (i < max) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append(')');
            return sb.toString();
        }
        return null;
    }

    public static TypeInfo getTypeInfo(ITypeHelper typeHelper, IJavaElement javaElement) throws CoreException {
        return typeHelper == null ? null : (javaElement instanceof IType ? typeHelper.getTypeInfo((IType)javaElement) : (javaElement instanceof IMethod ? typeHelper.getTypeInfo((IMethod)javaElement) : (javaElement instanceof ILocalVariable ? typeHelper.getTypeInfo((ILocalVariable)javaElement) : (javaElement instanceof IField ? typeHelper.getTypeInfo((IField)javaElement) : null))));
    }

    public static boolean equals(IType type1, IType type2) {
        if (DTRTUtil.equals(type1, type2)) {
            return true;
        }
        if (type1 != null && type2 != null) {
            return DTRTUtil.equals(type1.getElementName(), type2.getElementName()) && DTRTUtil.equals(type1.getHandleIdentifier(), type2.getHandleIdentifier());
        }
        return false;
    }

    public static boolean equals(IType type, Object object) {
        return object instanceof IType && JDTUtil.equals(type, (IType)object);
    }

    public static boolean addContainerClasspathEntry(IJavaProject javaProject, String path) throws JavaModelException {
        if (javaProject != null) {
            IClasspathEntry[] currentClasspathEntries;
            Path ipath = new Path(path);
            IClasspathEntry[] iClasspathEntryArray = currentClasspathEntries = javaProject.getRawClasspath();
            int n = currentClasspathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)ipath)) {
                    return false;
                }
                ++n2;
            }
            IClasspathEntry[] updatedClasspathEntries = new IClasspathEntry[currentClasspathEntries.length + 1];
            System.arraycopy(currentClasspathEntries, 0, updatedClasspathEntries, 0, currentClasspathEntries.length);
            updatedClasspathEntries[currentClasspathEntries.length] = JavaCore.newContainerEntry((IPath)ipath, (boolean)false);
            javaProject.setRawClasspath(updatedClasspathEntries, null);
            return true;
        }
        return false;
    }

    public static final class TypeKey {
        private final IType type;

        public TypeKey(IType type) {
            this.type = type;
        }

        public IType getType() {
            return this.type;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TypeKey other = (TypeKey)obj;
            return JDTUtil.equals(this.type, other.type);
        }
    }
}

