/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.jdt;

import java.util.Arrays;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;

public final class AnnotationMemberValue {
    private IAnnotation annotation;
    private String memberName;
    private ValueKind valueKind;
    private Object[] rawValues;
    private Object[] values;
    private ValuePair[] valuePairs;
    private boolean multiValue;

    AnnotationMemberValue(IAnnotation annotation, IMemberValuePair memberValuePair, boolean multiValue) {
        this.annotation = annotation;
        this.memberName = memberValuePair.getMemberName();
        this.multiValue = multiValue;
        this.valueKind = ValueKind.getValueKind(memberValuePair.getValueKind());
        if (memberValuePair.getValue() instanceof Object[]) {
            Object[] array = (Object[])memberValuePair.getValue();
            this.rawValues = array.length == 1 && array[0] == null ? DTRTUtil.EMPTY_ARRAY : (Object[])memberValuePair.getValue();
        } else {
            Object[] objectArray;
            if (memberValuePair.getValue() == null) {
                objectArray = DTRTUtil.EMPTY_ARRAY;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = memberValuePair.getValue();
            }
            this.rawValues = objectArray;
        }
    }

    public IAnnotation getAnnotation() {
        return this.annotation;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }

    public ValueKind getValueKind() {
        return this.valueKind;
    }

    public Object[] getRawValues() {
        return this.rawValues;
    }

    void setValues(Object[] values) {
        this.values = values;
    }

    public Object[] getValues() {
        return this.values;
    }

    public ValuePair[] getValuePairs() {
        if (this.valuePairs == null) {
            ValuePair[] valuePairs = new ValuePair[this.getRawValues().length];
            int i = 0;
            while (i < this.getRawValues().length) {
                valuePairs[i] = new ValuePair(i);
                ++i;
            }
            this.valuePairs = valuePairs;
        }
        return this.valuePairs;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.annotation == null ? 0 : this.annotation.hashCode());
        result = 31 * result + (this.memberName == null ? 0 : this.memberName.hashCode());
        result = 31 * result + Arrays.hashCode(this.rawValues);
        result = 31 * result + Arrays.hashCode(this.values);
        result = 31 * result + (this.valueKind == null ? 0 : this.valueKind.hashCode());
        result = 31 * result + (this.multiValue ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AnnotationMemberValue)) {
            return false;
        }
        AnnotationMemberValue other = (AnnotationMemberValue)obj;
        return this.valueKind == other.valueKind && this.multiValue == other.multiValue && DTRTUtil.equals(this.annotation, other.annotation) && DTRTUtil.equals(this.memberName, other.memberName) && DTRTUtil.equals(this.rawValues, other.rawValues) && DTRTUtil.equals(this.values, other.values);
    }

    public static enum ValueKind {
        ANNOTATION(10),
        BOOLEAN(8),
        BYTE(2),
        CHAR(4),
        CLASS(11),
        DOUBLE(6),
        FLOAT(5),
        INT(1),
        LONG(7),
        QUALIFIED_NAME(12),
        SHORT(3),
        SIMPLE_NAME(13),
        STRING(9),
        UNKNOWN(14);

        private int rawValueKind;

        public static ValueKind getValueKind(int rawValueKind) {
            ValueKind[] valueKindArray = ValueKind.values();
            int n = valueKindArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValueKind valueKind = valueKindArray[n2];
                if (valueKind.getRawValueKind() == rawValueKind) {
                    return valueKind;
                }
                ++n2;
            }
            return null;
        }

        private ValueKind(int rawValueKind) {
            this.rawValueKind = rawValueKind;
        }

        public int getRawValueKind() {
            return this.rawValueKind;
        }
    }

    public final class ValuePair {
        private int index;

        private ValuePair(int index) {
            this.index = index;
        }

        public Object getRawValue() {
            return AnnotationMemberValue.this.getRawValues()[this.index];
        }

        public Object getValue() {
            return AnnotationMemberValue.this.getValues()[this.index];
        }
    }
}

