/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.internal.DTRTBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;

public class ExtenderManager {
    public static final ExtenderManager INSTANCE = new ExtenderManager();
    private static final String EXTENSION_POINT_ELEMENT_NAME = "extender";
    private static final String EXTENSION_POINT_ID = "oracle.eclipse.tools.adf.dtrt.internal.extenders";
    private List<ExtenderHelper> helpers;
    private IRegistryEventListener registryEventListener;

    private ExtenderManager() {
    }

    public void reset() {
        this.helpers = null;
        if (this.registryEventListener != null) {
            Platform.getExtensionRegistry().removeListener(this.registryEventListener);
            this.registryEventListener = null;
        }
    }

    public <T> T getExtender(Class<T> baseClass) {
        if (baseClass != null) {
            this.initialize();
            if (this.helpers != null && !this.helpers.isEmpty()) {
                for (ExtenderHelper helper : this.helpers) {
                    T extender = helper.getExtender(baseClass);
                    if (extender == null) continue;
                    return extender;
                }
            }
        }
        return null;
    }

    private void initialize() {
        if (this.registryEventListener == null) {
            this.registryEventListener = new IRegistryEventListener(){

                public void added(IExtension[] extensions) {
                    IExtension[] iExtensionArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        ExtenderManager.this.initialize();
                        ExtenderManager.this.load(extension.getConfigurationElements());
                        ++n2;
                    }
                }

                public void removed(IExtension[] extensions) {
                    HashSet<String> contributorNames = new HashSet<String>(extensions.length / 2 + 1);
                    IExtension[] iExtensionArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        IContributor contributor = extension.getContributor();
                        if (contributor != null && contributor.getName() != null && contributorNames.add(contributor.getName())) {
                            ExtenderManager.this.unload(contributor.getName());
                        }
                        ++n2;
                    }
                }

                public void added(IExtensionPoint[] extensionPoints) {
                }

                public void removed(IExtensionPoint[] extensionPoints) {
                }
            };
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            extensionRegistry.addListener(this.registryEventListener, EXTENSION_POINT_ID);
            IExtensionPoint point = extensionRegistry.getExtensionPoint(EXTENSION_POINT_ID);
            if (point != null) {
                this.helpers = new ArrayList<ExtenderHelper>();
                this.load(point.getConfigurationElements());
            }
        }
    }

    private void load(IConfigurationElement[] configurationElements) {
        if (this.helpers != null) {
            IConfigurationElement[] iConfigurationElementArray = configurationElements;
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                if (EXTENSION_POINT_ELEMENT_NAME.equals(configurationElement.getName()) && configurationElement.getAttribute("baseClass") != null && configurationElement.getAttribute("class") != null) {
                    this.helpers.add(new ExtenderHelper(configurationElement));
                }
                ++n2;
            }
        }
    }

    private void unload(String contributorName) {
        if (this.helpers != null) {
            Iterator<ExtenderHelper> i = this.helpers.iterator();
            while (i.hasNext()) {
                ExtenderHelper helper = i.next();
                if (!helper.isFromContributor(contributorName)) continue;
                i.remove();
            }
        }
    }

    private static class ExtenderHelper {
        private IConfigurationElement configurationElement;
        private Class<?> baseClass;
        private Object extender;
        private String contributorName;

        public ExtenderHelper(IConfigurationElement configurationElement) {
            this.configurationElement = configurationElement;
        }

        public <T> T getExtender(Class<T> cls) {
            if (this.extender == null && this.configurationElement != null && this.configurationElement.isValid() && this.configurationElement.getContributor() != null) {
                try {
                    this.baseClass = Class.forName(this.configurationElement.getAttribute("baseClass"), true, this.getClass().getClassLoader());
                }
                catch (Throwable t) {
                    this.baseClass = null;
                    DTRTBundle.log("Unable to load base class from " + this.configurationElement, t);
                }
                if (this.baseClass == cls) {
                    Object object;
                    try {
                        object = this.configurationElement.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        object = null;
                        DTRTBundle.log("Unable to create executable extension from " + this.configurationElement, e);
                    }
                    if (object != null && this.baseClass.isInstance(object)) {
                        this.extender = object;
                        this.contributorName = this.configurationElement.getContributor().getName();
                    } else {
                        this.baseClass = null;
                    }
                }
            }
            if (this.baseClass == null) {
                this.configurationElement = null;
                return null;
            }
            return this.baseClass == cls && this.extender != null ? (T)cls.cast(this.extender) : null;
        }

        public boolean isFromContributor(String name) {
            return name != null && this.contributorName != null && this.contributorName.equals(name);
        }
    }
}

