/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.impl;

import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public final class DTRTLog
implements ILog {
    private static final String LOG_ENABLED = "dtrtLogEnabled";
    private static final String BUNDLE_LOG_ENABLED = "dtrtBundleLogEnabled";
    private final String bundleId;
    private TypedListenerList<ILogListener> logListenerList;
    private boolean logEnabled = false;

    public DTRTLog(String bundleId) {
        if (bundleId == null) {
            throw new IllegalArgumentException("bundleId cannot be null");
        }
        this.bundleId = bundleId;
        this.logListenerList = new TypedListenerList();
    }

    private ILog getPlatformLog() {
        Bundle bundle = this.getBundle();
        return bundle != null ? Platform.getLog((Bundle)bundle) : null;
    }

    public void setLogEnabled(boolean enabled) {
        this.logEnabled = enabled;
    }

    public boolean isLogEnabled() {
        return this.logEnabled || Boolean.getBoolean(LOG_ENABLED) || this.bundleId.equals(System.getProperty(BUNDLE_LOG_ENABLED));
    }

    public Bundle getBundle() {
        return Platform.isRunning() ? Platform.getBundle((String)this.bundleId) : null;
    }

    public void addLogListener(ILogListener listener) {
        ILog platformLog = this.getPlatformLog();
        if (platformLog != null) {
            platformLog.addLogListener(listener);
        } else {
            this.logListenerList.add(listener);
        }
    }

    public void removeLogListener(ILogListener listener) {
        ILog platformLog = this.getPlatformLog();
        if (platformLog != null) {
            platformLog.removeLogListener(listener);
        } else {
            this.logListenerList.remove(listener);
        }
    }

    public void log(String message, Throwable throwable) {
        if (this.isLogEnabled()) {
            this.log((IStatus)new Status(4, this.bundleId, message, throwable));
        }
    }

    public void log(Throwable throwable) {
        if (this.isLogEnabled()) {
            String message = throwable.getLocalizedMessage();
            if (message == null) {
                message = DTRTUtil.toNotNullString(throwable.getMessage());
            }
            this.log((IStatus)new Status(4, this.bundleId, message, throwable));
        }
    }

    public void log(IStatus status) {
        if (this.isLogEnabled()) {
            ILog platformLog = this.getPlatformLog();
            if (platformLog != null) {
                platformLog.log(status);
            } else {
                System.out.println(status);
                for (ILogListener logListener : this.logListenerList) {
                    logListener.logging(status, this.bundleId);
                }
            }
        }
    }
}

