/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.command;

import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public interface ICommand {
    public void dispose();

    public boolean isDisposed();

    public ICommandStack getCommandStack();

    public String getLabel();

    public CommandOperation getLastOperation();

    public List<?> getAffectedObjects();

    public IStatus canExecute();

    public IStatus canUndo();

    public IStatus canRedo();

    public void execute(IProgressMonitor var1) throws Exception;

    public void undo(IProgressMonitor var1) throws Exception;

    public void redo(IProgressMonitor var1) throws Exception;

    public static enum CommandOperation {
        EXECUTION,
        UNDO,
        REDO;


        public static CommandOperation nextOperation(ICommand command) {
            if (DTRTUtil.isNotDisposed(command)) {
                return command.getLastOperation() == null ? EXECUTION : (command.getLastOperation() == UNDO ? REDO : UNDO);
            }
            return null;
        }
    }
}

