/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.CommandMessages;
import oracle.eclipse.tools.adf.dtrt.command.ICloneableCommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ObjectList;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public final class CompoundCommand
implements ICloneableCommand,
Iterable<ICommand> {
    private String label;
    private ICommandStack commandStack;
    private ICommand.CommandOperation lastOperation;
    private List<ICommand> commands;
    private ObjectList<Object> affectedObjects;

    public CompoundCommand(String label) {
        assert (label != null);
        this.label = label;
        this.commands = new ArrayList<ICommand>();
    }

    @Override
    public void dispose() {
        this.label = null;
        this.commandStack = null;
        if (this.commands != null) {
            for (ICommand command : this.commands) {
                try {
                    command.dispose();
                }
                catch (Exception exception) {}
            }
            this.commands.clear();
            this.commands = null;
        }
        if (this.affectedObjects != null) {
            this.affectedObjects.clear();
            this.affectedObjects = null;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.commands == null;
    }

    @Override
    public ICommandStack getCommandStack() {
        return this.commandStack;
    }

    private final void checkExecuted() {
        if (this.lastOperation != null) {
            throw new IllegalStateException("The command has been executed");
        }
    }

    public CompoundCommand addCommand(ICommand command) throws IllegalArgumentException {
        if (command != null) {
            this.checkExecuted();
            if (this.commandStack == null) {
                this.commandStack = command.getCommandStack();
            } else if (this.commandStack != command.getCommandStack()) {
                throw new IllegalArgumentException("The command stack of the added command must be the same as the one for the compound command.");
            }
            assert (this.commandStack != null);
            if (command.getLastOperation() != this.lastOperation) {
                throw new IllegalArgumentException("The last operation of the added command must be the same as the one for the compound command.");
            }
            this.commands.add(command);
        }
        return this;
    }

    public CompoundCommand addCommands(ICommand ... commands) {
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            this.addCommand(command);
            ++n2;
        }
        return this;
    }

    public CompoundCommand addCommands(Collection<? extends ICommand> commands) {
        for (ICommand iCommand : commands) {
            this.addCommand(iCommand);
        }
        return this;
    }

    public CompoundCommand removeCommand(ICommand command) {
        this.checkExecuted();
        this.commands.remove(command);
        return this;
    }

    @Override
    public Iterator<ICommand> iterator() {
        return this.commands == null ? Collections.emptyList().iterator() : (this.getLastOperation() == null ? this.commands.iterator() : Collections.unmodifiableList(this.commands).iterator());
    }

    public int size() {
        return this.commands != null ? this.commands.size() : 0;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public ICommand.CommandOperation getLastOperation() {
        return this.lastOperation;
    }

    @Override
    public List<?> getAffectedObjects() {
        return this.affectedObjects != null ? this.affectedObjects.getUnmodifiableView() : Collections.emptyList();
    }

    @Override
    public IStatus canExecute() {
        return this.canPerformOperation(ICommand.CommandOperation.EXECUTION);
    }

    @Override
    public IStatus canUndo() {
        return this.canPerformOperation(ICommand.CommandOperation.UNDO);
    }

    @Override
    public IStatus canRedo() {
        return this.canPerformOperation(ICommand.CommandOperation.REDO);
    }

    private IStatus canPerformOperation(ICommand.CommandOperation operation) {
        ArrayList<IStatus> notOKStatus = new ArrayList<IStatus>(this.commands.size());
        if (this.commands.isEmpty()) {
            notOKStatus.add(DTRTUtil.createErrorStatus("The compound command has no commands."));
        } else {
            for (ICommand command : this.commands) {
                IStatus status;
                if (command.isDisposed()) continue;
                if (this.getCommandStack() != command.getCommandStack()) {
                    status = DTRTUtil.createErrorStatus("The command stack of each command must be the same as the one for the compound command (command: %s).", command.getLabel());
                } else if (this.getLastOperation() != command.getLastOperation()) {
                    status = DTRTUtil.createErrorStatus("The last operation of each command must be the same as the one for the compound command (command: %s).", command.getLabel());
                } else {
                    switch (operation) {
                        case EXECUTION: {
                            status = command.canExecute();
                            break;
                        }
                        case UNDO: {
                            status = command.canUndo();
                            break;
                        }
                        case REDO: {
                            status = command.canRedo();
                            break;
                        }
                        default: {
                            status = Status.CANCEL_STATUS;
                        }
                    }
                }
                if (status == null || status.isOK()) continue;
                notOKStatus.add(status);
            }
        }
        if (!notOKStatus.isEmpty()) {
            MultiStatus status = new MultiStatus("oracle.eclipse.tools.adf.dtrt", 0, notOKStatus.toArray(new IStatus[notOKStatus.size()]), CommandMessages.getCannotPerformOperationMessage(this, operation), null);
            return status;
        }
        return Status.OK_STATUS;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws Exception {
        this.performOperation(ICommand.CommandOperation.EXECUTION, monitor);
    }

    @Override
    public void undo(IProgressMonitor monitor) throws Exception {
        this.performOperation(ICommand.CommandOperation.UNDO, monitor);
    }

    @Override
    public void redo(IProgressMonitor monitor) throws Exception {
        this.performOperation(ICommand.CommandOperation.REDO, monitor);
    }

    private void performOperation(ICommand.CommandOperation operation, IProgressMonitor monitor) throws Exception {
        if (this.affectedObjects != null) {
            this.affectedObjects.clear();
        }
        if (operation == ICommand.CommandOperation.EXECUTION) {
            ArrayList<ICommand> list = new ArrayList<ICommand>(this.commands);
            this.commands.clear();
            this.commands = list;
        }
        if (!this.commands.isEmpty()) {
            int increment;
            int end;
            int start;
            ObjectList tempAffectedObjects = new ObjectList(this.commands.size());
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)this.commands.size());
            if (operation == ICommand.CommandOperation.UNDO) {
                start = this.commands.size() - 1;
                end = -1;
                increment = -1;
            } else {
                start = 0;
                end = this.commands.size();
                increment = 1;
            }
            int i = start;
            while (i != end) {
                ICommand command = this.commands.get(i);
                if (!command.isDisposed()) {
                    switch (operation) {
                        case EXECUTION: {
                            command.execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                            break;
                        }
                        case UNDO: {
                            command.undo(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                            break;
                        }
                        case REDO: {
                            command.redo(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                        }
                    }
                    for (Object object : command.getAffectedObjects()) {
                        if (tempAffectedObjects.contains(object)) continue;
                        tempAffectedObjects.add(object);
                    }
                }
                i += increment;
            }
            this.lastOperation = operation;
            if (this.affectedObjects == null) {
                this.affectedObjects = tempAffectedObjects;
            } else {
                this.affectedObjects.addAll(tempAffectedObjects);
            }
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    @Override
    public CompoundCommand clone() {
        return new CompoundCommand(this.getLabel()).addCommands(this.commands);
    }
}

