/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSNonPositiveInteger
extends XSInteger {
    private static final String XS_NON_POSITIVE_INTEGER = "xs:nonPositiveInteger";

    public XSNonPositiveInteger() {
        this(BigInteger.valueOf(0L));
    }

    public XSNonPositiveInteger(BigInteger x) {
        super(x);
    }

    public String string_type() {
        return XS_NON_POSITIVE_INTEGER;
    }

    public String type_name() {
        return "nonPositiveInteger";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.getStringValue());
            BigInteger max = BigInteger.valueOf(0L);
            if (bigInt.compareTo(max) > 0) {
                throw DynamicError.cant_cast(null);
            }
            return new XSNonPositiveInteger(bigInt);
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }

    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_NONPOSITIVEINTEGER;
    }

    public Object getNativeValue() {
        return new Long(this.getValue().longValue());
    }
}

