/*
 * Decompiled with CFR 0.152.
 */
package oracle.nuviaq.common;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.nuviaq.common.TimeOutable;

public class TimeOutHandler {
    private TimeOutable currentAction;
    private String handle;
    private static Logger logger = Logger.getLogger("oracle.nuviaq");
    private static Map<String, TimeOutHandler> handlers = new ConcurrentHashMap<String, TimeOutHandler>();

    private static Map<String, TimeOutHandler> getHandlers() {
        return handlers;
    }

    public static void register(String handle, TimeOutable action) {
        TimeOutHandler handler = TimeOutHandler.getHandlers().get(handle);
        if (handler == null) {
            handler = new TimeOutHandler();
            handler.init(handle, action);
            TimeOutHandler.getHandlers().put(handle, handler);
        } else {
            handler.init(handle, action);
        }
    }

    public static void remove(String handle) {
        TimeOutHandler.getHandlers().remove(handle);
    }

    public static void checkTimeOutHandlers() {
        for (TimeOutHandler handler : TimeOutHandler.getHandlers().values()) {
            try {
                handler.checkAndTimeOut();
            }
            catch (RuntimeException e) {
                logger.warning("Runtime Exception during timeout handling");
                logger.warning(e.getMessage());
            }
        }
    }

    private void init(String id, TimeOutable action) {
        this.currentAction = action;
        this.currentAction.setStartTime(new Date().getTime());
        this.handle = id;
    }

    private String formatTime(long time) {
        String result = "";
        String zero = "0";
        String sep = ":";
        long mills = time % 1000L;
        long rem = time / 1000L;
        long sec = rem % 60L;
        long hours = rem / 3600L;
        long min = rem / 60L - hours * 60L;
        result = result + hours + sep;
        if (min < 10L) {
            result = result + zero;
        }
        result = result + min + sep;
        if (sec < 10L) {
            result = result + zero;
        }
        result = result + sec + sep;
        if (mills < 10L) {
            result = result + zero;
        }
        if (mills < 100L) {
            result = result + zero;
        }
        result = result + mills;
        return result;
    }

    private String getHandle() {
        return this.handle;
    }

    private void checkAndTimeOut() {
        if (this.currentAction.isTimedOut()) {
            return;
        }
        long currentTime = new Date().getTime();
        long elapsed = currentTime - this.currentAction.getStartTime();
        if (elapsed > this.currentAction.timeOutLimit()) {
            logger.warning("Attempting time out of: " + this.getHandle() + " / " + this.currentAction.toString());
            logger.warning("Elapsed time of " + this.formatTime(elapsed) + " is greater than time out limit of " + this.formatTime(this.currentAction.timeOutLimit()));
            this.currentAction.handleTimeOut();
        }
    }
}

