/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.model;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="Exception", namespace="http://xmlns.oracle.com/cloud/paas/1.0")
@XmlType(name="ExceptionType", namespace="http://xmlns.oracle.com/cloud/paas/1.0")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExceptionWrapper {
    @XmlElement(name="Type")
    private String type;
    @XmlElement(name="Message")
    private String message;
    @XmlElement(name="Args")
    private String[] args;
    @XmlElement(name="StackTrace")
    private String stackTrace;

    public ExceptionWrapper() {
    }

    public ExceptionWrapper(String type, String message, String ... args) {
        this.type = type;
        this.message = message;
        this.args = args;
    }

    public ExceptionWrapper(String type, String message, Throwable ex) {
        this(type, message, ex, (String[])null);
    }

    public ExceptionWrapper(String type, String message, Throwable ex, String ... args) {
        this.type = type;
        this.message = message;
        this.args = args;
        if (ex != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            this.stackTrace = sw.toString();
            pw.close();
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String ... args) {
        this.args = args;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }
}

