/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import oracle.cloud.paas.internal.Helper;

public class DateTimeXmlAdapter
extends XmlAdapter<String, Date> {
    public String marshal(Date date) throws Exception {
        return Helper.printSILogFormatDate(date);
    }

    public Date unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        int len = v.length();
        if (v.charAt(len - 3) == ':') {
            v = v.substring(0, len - 3) + v.substring(len - 2);
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(v);
        }
        catch (ParseException ex) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(v);
        }
    }
}

